from datetime import datetime, timedelta
import tarfile
from plot.parser import parse_lines, LogParser


def parse(pr, infile, db, tablename):
    def ms_since_epoch(logstart, interval):
        # helper to create a generator for adding timestamps to 
        # parsed loglines
        # workaround missing nonlocal to implement closure
        nonlocal = {
            'logstart' : logstart,
            'interval': int(interval)
            }

        def gen(**kw_args):
            if 'rxpck' in kw_args and kw_args['iface'] == 'lo':
                # workaround for broken timestamps in sar log headers on centos
                nonlocal['logstart'] += timedelta(seconds=nonlocal['interval'])
            return nonlocal['logstart'].strftime('%s%f')[:13]
        return gen

    # read logstart and interval from file
    match = pr.compile_regex('%{COUNTER_START}').match(
        infile.readline()).groupdict()

    callbacks = {'ms_since_epoch': ms_since_epoch(
        datetime.strptime(match['logstart'], '%Y%m%d %H%M%S'),
        match['interval'])
    }

    # parse the data from the logfiles
    dev = LogParser(pr.compile_regex('%{LINUX_SAR_DEV}'), callbacks, db, '%s_dev' % tablename)
    edev = LogParser(pr.compile_regex('%{LINUX_SAR_EDEV}'), callbacks, db, '%s_edev' % tablename)
    discard = LogParser(pr.compile_regex('%{LINUX_SAR_DISCARD}'))
    parse_lines([dev, edev, discard], infile)


def populate(pr, filename, db, testrun, tablename):
    with tarfile.open(filename, mode="r:gz") as tar:
        infile = tar.extractfile('./sar.txt.%s' % testrun)
        parse(pr, infile, db, tablename)


def query(db, tablename, arguments=[]):
    c = db.cursor()
    # select the data from both dev and edev tables
    c.execute('select dev.ms_since_epoch, dev.rxkB, dev.txkB, edev.coll, edev.rxerr, edev.txerr '
        + 'from %s as dev, %s as edev ' % ('%s_dev' % tablename, '%s_edev' % tablename)
        + 'where dev.ms_since_epoch = edev.ms_since_epoch and dev.iface = edev.iface and dev.iface = "eth0" '
        + 'order by dev.ms_since_epoch')

    rows = c.fetchall()
    headers = tuple([h[0] for h in c.description])
    c.close()
    return [headers] + rows
