#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
(c) Mark Fink, 2008 - 2013
This script is released under the MIT License
Warranty in any form is excluded
"""

from os.path import join
from rctl.commands import puts, upload, run

### Supercars
def deploy_supercars(env, ssh):
    puts('deploying the supercars application')
    upload(ssh, join('rctl_shelf', 'supercars'), join(env['appfolder'], 'supercars'))

def start_supercars(env, ssh):
    puts('starting the supercars application')
    run(ssh, 'cd %s ; ./scripts/restserver.sh start' %
        join(env['appfolder'], 'supercars'))

def stop_supercars(env, ssh):
    puts('stopping the supercars application')
    run(ssh, 'cd %s ; ./scripts/restserver.sh stop' %
        join(env['appfolder'], 'supercars'))
