from selenium.webdriver.remote.webdriver import WebDriver
from selenium.webdriver.common.desired_capabilities import DesiredCapabilities
from selenium.webdriver.common.by import By

from hamcrest import assert_that, equal_to, greater_than, is_, contains_string
import random


class SupercarsCreateTest():
    
    def __init__(self, log, thinktime, url, queue, hub=None, webdriver=None):
        self.log = log
        self.thinktime = thinktime
        self.url = url
        self.hub = hub
        self.webdriver = webdriver
        self.queue = queue

    def setup(self):
        if self.webdriver:
            from selenium import webdriver
            self.browser = getattr(webdriver, self.webdriver)()
        else:
            self.browser = WebDriver(command_executor=str(self.hub), 
                desired_capabilities=DesiredCapabilities.PHANTOMJS)

    def run(self):
        # test_url
        self.log('start_page', 'start')
        self.browser.get(self.url)
        assert_that(self.browser.title, is_('Angular Supercars'))

        # check that it has more than 10 elements
        entries = self.browser.find_elements(By.CSS_SELECTOR, 'div#sidebar ul li a')
        assert_that(len(entries), greater_than(10))
        self.log('start_page', 'end')
        self.thinktime(5)


        # create
        self.log('enter_details_page', 'start')
        self.browser.find_element(By.ID, 'newButton').click()
        name = 'PerfTest_%d' % random.randint(0,99999)

        self.browser.find_element(By.ID, 'nameInput').send_keys(name)
        self.browser.find_element(By.ID, 'countryInput').send_keys('Italy')
        self.browser.find_element(By.ID, 'topSpeedInput').send_keys('218')
        self.browser.find_element(By.ID, 'powerInput').send_keys('650')
        self.browser.find_element(By.ID, 'engineInput').send_keys('5998')
        self.browser.find_element(By.ID, 'weightInput').send_keys('1365')
        self.browser.find_element(By.ID, 'imageInput').send_keys('050.jpg')
        self.browser.find_element(By.ID, 'descriptionTextarea').send_keys('created by performance test')
        self.browser.find_element(By.ID, 'saveButton').click()

        # verify that the new car is contained in the list
        assert_that(self.browser.find_element(By.CSS_SELECTOR, 'div#sidebar').text, contains_string(name))
        self.log('enter_details_page', 'end')

        # add the new car to the queue
        self.queue.lpush(name)

    def teardown(self):
        self.browser.quit()
