from selenium.webdriver.remote.webdriver import WebDriver
from selenium.webdriver.common.desired_capabilities import DesiredCapabilities
from selenium.webdriver.common.by import By

from hamcrest import assert_that, equal_to, greater_than, is_, contains_string
import random


class SupercarsUpdateTest():

    def __init__(self, log, thinktime, url, queue, hub=None, webdriver=None):
        self.log = log
        self.thinktime = thinktime
        self.url = url
        self.hub = hub
        self.webdriver = webdriver
        self.queue = queue

    def setup(self):
        if self.webdriver:
            from selenium import webdriver
            self.browser = getattr(webdriver, self.webdriver)()
        else:
            self.browser = WebDriver(command_executor=str(self.hub), 
                desired_capabilities=DesiredCapabilities.PHANTOMJS)

    def run(self):
        # test_url
        self.log('start_page', 'start')
        self.browser.get(self.url)
        assert_that(self.browser.title, is_('Angular Supercars'))

        # check that it has more than 10 elements
        entries = self.browser.find_elements(By.CSS_SELECTOR, 'div#sidebar ul li a')
        assert_that(len(entries), greater_than(10))
        self.log('start_page', 'end')
        self.thinktime(5)

        # get name from queue
        car = self.queue.rpop()

        if car:
            # find PerfTest_ entries
            entries = self.browser.find_elements(By.PARTIAL_LINK_TEXT, car)
            if len(entries):
                self.log('details_page', 'start')
                # random.choice(entries).click()
                entries[0].click()

                # car = self.browser.find_element(By.ID, 'nameInput').get_attribute('value')
                car += str(random.randint(0, 9))

                print 'car %s' % car
                self.log('details_page', 'end')
                # self.thinktime(5) # reduce the chance that s.o. else deletes or updates this one

                self.log('update', 'start')
                self.browser.find_element(By.ID, 'nameInput').clear();
                self.browser.find_element(By.ID, 'nameInput').send_keys(car);
                self.browser.find_element(By.ID, 'saveButton').click();

                # verify that the updated car is contained in the list
                assert_that(self.browser.find_element(By.CSS_SELECTOR, 'div#sidebar').text, contains_string(car))
                self.log('update', 'end')

                # add the updated car to the queue
                self.queue.lpush(car)


    def teardown(self):
        self.browser.quit()
