'''jvm plugin for aogaeru plot'''
from datetime import datetime, timedelta
import os
import tarfile
import regex
from plot.parser import LogParser
import logging


def parse_lines(log_parsers, fileinp, state):
    """this logfile has multiline logentries, consequently it needs a specialised parser"""
    while 1:
        logentry = fileinp.readline()
        if logentry.startswith('{Heap before GC'):
            while 1:
                nextline = fileinp.readline()
                if not nextline:
                    logentry = None
                    break
                logentry += nextline
                if (nextline.startswith("}")):
                    break
        else:
            if not logentry:
                break
            else:
                continue

        if not logentry:
            break

        # print 'logentry: %s' % logentry
        for lp in log_parsers:
            if lp.parse(logentry):
                pass
        else:
            # error: none of the logparsers worked on the line
            logger = logging.getLogger('logparser')
            logger.warning(
                'Could not parse line >>>%s<<<', logentry.rstrip())
        state['invocations'] += 1


def parse(pr, infile, db, tablename):
    state = {'invocations': 0}  # exchange From-To after each Gc run
    def gc_timestamp(ts):
        # format 2013-07-18T15:34:38.648+0200
        def timezone(zone):
            # format '+0000'
            return timedelta(hours= int(zone[:3]), minutes= int(zone[:1]+zone[3:]))

        res = datetime.strptime(ts[:-5], '%Y-%m-%dT%H:%M:%S.%f')
        return (res + timezone(ts[-5:])).strftime('%s%f')[:13]

    def gc_timestamp_after(ts, dur):
        # format 2013-07-18T15:34:38.648+0200
        def timezone(zone):
            # format '+0000'
            return timedelta(hours= int(zone[:3]), minutes= int(zone[:1]+zone[3:]))

        def duration(dur):
            # format '9.1234567' in seconds
            sec, ms = dur.split('.')
            return timedelta(seconds=int(sec), microseconds= int((ms+'000000')[:6]))

        res = datetime.strptime(ts[:-5], '%Y-%m-%dT%H:%M:%S.%f')
        return (res + timezone(ts[-5:]) + duration(dur)).strftime('%s%f')[:13]

    def ms_since_epoch(**kw_args):
        return gc_timestamp(kw_args['datetime'])

    def ms_since_epoch_after(**kw_args):
        return gc_timestamp_after(kw_args['datetime'], kw_args['duration'])

    def full_gc_occured(**kw_args):
        if kw_args['type'] == 'Full GC':
            return 1
        else:
            return 0

    def edenUsed(**kw_args):
        return int(kw_args['edenSize']) * int(kw_args['edenPrc']) // 100

    def fromUsed(**kw_args):
        return int(kw_args['fromSize']) * int(kw_args['fromPrc']) // 100

    def toUsed(**kw_args):
        return int(kw_args['toSize']) * int(kw_args['toPrc']) // 100

    def fromTo(**kw_args):
        # print 'from state: %s' % state['from_to']
        # if state['from_to'] == 'from':
        if state['invocations'] % 2 == 0:
            return fromUsed(**kw_args)
        else:
            return toUsed(**kw_args)

    def toFrom(**kw_args):
        # print 'to state: %s' % state['from_to']
        if state['invocations'] % 2 == 0:
            return toUsed(**kw_args)
        else:
            return fromUsed(**kw_args)


    # from the gcview implementation
    # def fromUsed(**kw_args):
    #     #if status['last_from'] == 0:
    #     if state['invocations'] % 2 == 0:
    #         return int(kw_args['fromSize']) * int(kw_args['toPrc']) // 100
    #     else:
    #         return int(kw_args['fromSize']) * int(kw_args['fromPrc']) // 100

    # def toUsed(**kw_args):
    #     if state['invocations'] % 2 == 0:
    #         return int(kw_args['toSize']) * int(kw_args['fromPrc']) // 100
    #     else:
    #         return int(kw_args['toSize']) * int(kw_args['toPrc']) // 100
 
    # def fromUsed_after(**kw_args):
    #     if state['invocations'] % 2 == 0:
    #         return int(kw_args['fromSize']) * int(kw_args['fromPrc']) // 100
    #     else:
    #         return int(kw_args['fromSize']) * int(kw_args['toPrc']) // 100

    # def toUsed_after(**kw_args):
    #     if state['invocations'] % 2 == 0:
    #         return int(kw_args['toSize']) * int(kw_args['toPrc']) // 100
    #     else:
    #         return int(kw_args['toSize']) * int(kw_args['fromPrc']) // 100




    # note: exchange From-To after each Gc run
    callbacks = { 
        'ms_since_epoch': ms_since_epoch, 
        'edenUsed': edenUsed,
        # 'fromUsed': fromUsed,
        # 'toUsed': toUsed,
        'fromUsed': toFrom,
        'toUsed': fromTo,
        'fullGC': full_gc_occured,
        'elapsed': lambda **kw_args: kw_args['duration']
    }
    callbacks_after = { 
        'ms_since_epoch': ms_since_epoch_after,
        'edenUsed': edenUsed,
        # 'fromUsed': fromUsed_after,
        # 'toUsed': toUsed_after,
        'fromUsed': fromTo,
        'toUsed': toFrom,
        'fullGC': lambda **kw_args: 0,
        'elapsed': lambda **kw_args: 0
    }

    # parse the data from the logfiles
    gc = LogParser(pr.compile_regex('%{JVM_GC}', 
        regex.MULTILINE|regex.DOTALL), callbacks, db, tablename)
    gc_after = LogParser(pr.compile_regex('%{JVM_GC_AFTER}', 
        regex.MULTILINE|regex.DOTALL), callbacks_after, db, tablename)
    parse_lines([gc, gc_after], infile, state)


def populate(pr, filename, db, testrun, tablename):
    with tarfile.open(filename, mode="r:gz") as tar:
        # read in all access logfiles
        for tarinfo in tar:
            if tarinfo.isreg():
                print 'working on %s' % tarinfo
                infile = tar.extractfile(tarinfo.name)
                parse(pr, infile, db, '%s_%s' % (tablename, 
                    regex.sub('[^\w_]+', '', os.path.splitext(tarinfo.name)[0])))


def query(db, tablename, arguments=[]):
    c = db.cursor()
    c.execute('select * from %s order by ms_since_epoch' % tablename)
    # c.execute('select * from %s' % tablename)

    rows = c.fetchall()
    headers = tuple([h[0] for h in c.description])
    c.close()
    return [headers] + rows
