from datetime import datetime, timedelta
import tarfile
from plot.parser import parse_lines, LogParser


def parse(pr, infile, db, tablename):
    def ms_since_epoch(logstart, interval):
        # helper to create a generator for adding timestamps to
        # parsed loglines
        # workaround to implement missing closure
        nonlocal = {
            'logstart': logstart,
            'interval': int(interval)
            }

        def gen(**kw_args):
            nonlocal['logstart'] += timedelta(
                seconds=nonlocal['interval'])
            return nonlocal['logstart'].strftime('%s%f')[:13]
        return gen

    # read logstart and interval from file
    match = pr.compile_regex('%{COUNTER_START}').match(
        infile.readline()).groupdict()

    callbacks = {'ms_since_epoch': ms_since_epoch(
        datetime.strptime(match['logstart'], '%Y%m%d %H%M%S'),
        match['interval'])
    }

    # parse the data from the logfiles
    vmstat = LogParser(pr.compile_regex('%{LINUX_VMSTAT}'), callbacks, db, tablename)
    discard = LogParser(pr.compile_regex('%{LINUX_VMSTAT_DISCARD}'))
    parse_lines([vmstat, discard], infile)


def populate(pr, filename, db, testrun, tablename):
    with tarfile.open(filename, mode="r:gz") as tar:
        infile = tar.extractfile('./vmstat.txt.%s' % testrun)
        parse(pr, infile, db, tablename)


def query(db, tablename, arguments=[]):
    c = db.cursor()
    c.execute('select * from %s order by ms_since_epoch' % tablename)

    rows = c.fetchall()
    headers = tuple([h[0] for h in c.description])
    c.close()
    return [headers] + rows
