#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
(c) Mark Fink, 2008 - 2013
This script is released under the MIT License
Warranty in any form is excluded
"""
import re
import os
from os.path import join
from rctl.commands import puts, upload, run, download


def deploy_counters(env, ssh):
    puts('deploying the counters')
    upload(ssh, join('rctl_shelf', 'counters'), env['appfolder'])


def start_oscounters(env, ssh, args):
    puts('execute the oscounters script')
    run(ssh, 'cd %s; nohup ./oscounters.sh %s' % 
        (join(env['appfolder'], 'counters'), args))


#### collect
def zip_files(ssh, remotedir, pattern, archive):
    '''zip all the files on remote which follow a given pattern'''
    stdin, stdout, sterr = ssh.exec_command('cd %s; find -L . -regex "%s" ' % (remotedir, pattern) + 
        '-type f -print | xargs tar cf - | gzip -c > %s' % archive)

    # exec_command is non-blocking, wait for exit status
    channel = stdout.channel.recv_exit_status()


def testrun_folder(targetdir, testrun):
    '''make sure testrun folder exists'''
    if not os.path.exists(os.path.join(targetdir, testrun)):
        os.makedirs(os.path.join(targetdir, testrun))


def remove_files(ssh, remotedir, pattern):
    '''remove all files on remote'''
    stdin, stdout, sterr = ssh.exec_command('cd %s; find -L . -regex "%s" ' % 
        (remotedir, pattern) + '-type f -print | xargs rm ')

    # exec_command is non-blocking, wait for exit status
    channel = stdout.channel.recv_exit_status()


def collect_oscounters(config, env, ssh):
    puts('zip the OS counters on remote and collect them')
    # return collect(environments, logtypes, testrun, './testruns/')
    remotedir = join(env['appfolder'], 'counters')
    environment = env['host']
    targetdir = config['testruns']
    # get the pid(s)
    ssh_stdin, ssh_stdout, ssh_stderr = ssh.exec_command('cd %s; ls *.pid' % 
        join(remotedir, '_os'))
    try:
        while ssh_stdout:
            pid = re.match('^(\d{8})\.pid$', ssh_stdout.next()).group(1) # for all pids
            zip_files(ssh, '%s/_os/' % remotedir, '^.*\.txt\.%s$' % pid, 
                '%s/%s-oscounters-%s.tgz' % (remotedir, environment, pid))
            testrun_folder(targetdir, pid)
            download(ssh, '%s/%s-oscounters-%s.tgz' % (remotedir, environment, pid),
                join(targetdir, pid))
            # remove the files on remote
            remove_files(ssh, remotedir, './%s-oscounters-%s.tgz' % (environment, pid))
            remove_files(ssh, '%s/_os/' % remotedir, '^.*\.txt\.%s$' % pid)
            remove_files(ssh, '%s/_os/' % remotedir, '^.*%s.pid$' % pid)
    except StopIteration:
        pass
