#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
(c) Mark Fink, 2008 - 2013
This script is released under the MIT License
Warranty in any form is excluded
"""
from os.path import join
from httplib import HTTPConnection
from rctl.commands import puts, upload, run, wget, check_os


### PhantomJS
def deploy_phantomjs(env, ssh):
    puts('deploying phantomjs binary')
    # upload(ssh, join('shelf', 'phantomjs', env['bit']), env['appfolder'])
    os = check_os(ssh)
    if os['bit'] == '64':
        version = 'phantomjs-1.9.2-linux-x86_64'
    else:
        version = 'phantomjs-1.9.2-linux-i686'
    wget(ssh, 'https://phantomjs.googlecode.com/files/%s.tar.bz2' % version
        , env['appfolder'])
    run(ssh, 'cd %s; tar jxvf %s.tar.bz2 %s/bin/phantomjs --strip-components=2; '
        % (env['appfolder'], version, version)
        + 'rm %s.tar.bz2' % version)

def start_phantomjs(config, env, ssh):
    def new_instance(port):
        puts('starting phantomjs instance at port %s' % port,
            m_type='info')
        run(ssh, 'cd %s ; nohup ./%s --webdriver=%s '
            '--webdriver-selenium-grid-hub='
            'http://%s:%s/grid/register '
            '>/dev/null 2>&1 &' % 
            (env['appfolder'],
            config['phantomjs_bin'], port, 
            config['selenium_hub_host'],
            config['selenium_hub_port']))

    puts('starting %s phantomjs instances' % 
        config['phantomjs_instances'])
    for port in range(int(config['phantomjs_first_port']), 
            int(config['phantomjs_first_port']) +
            int(config['phantomjs_instances'])):
        new_instance(port)

def stop_phantomjs(config, env, ssh):
    def stop_instance(port):
        puts('stopping phantomjs instance at port %s' % port,
            m_type='info')
        conn = HTTPConnection(env['host'], port)
        conn.request('GET', '/shutdown')
        #print conn.getresponse().read()

    puts('stopping phantomjs instances')
    for port in range(int(config['phantomjs_first_port']), 
            int(config['phantomjs_first_port']) +
            int(config['phantomjs_instances'])):
        stop_instance(port)


### Selenium node
def start_selenium_nodes(config, env, ssh):
    def new_instance(port):
        puts('starting selenium node instance at port %s' % 
            port, m_type='info')
        run(ssh, 'export DISPLAY=:0; cd %s; '
            'nohup java -jar ./%s -port %s '
            '-role node -hub http://%s:%s/grid/register '
            '>/dev/null 2>&1 &' % 
            (env['appfolder'],
            config['selenium_jar'], port, 
            config['selenium_hub_host'],
            config['selenium_hub_port']))

    puts('starting %s selenium node instances' % 
        config['selenium_node_instances'])
    for port in range(int(config['selenium_node_first_port']), 
            int(config['selenium_node_first_port']) +
            int(config['selenium_node_instances'])):
        new_instance(port)

def stop_selenium_nodes(config, env, ssh):
    def stop_instance(port):
        puts('stopping selenium node instance at port %s' % port,
            m_type='info')
        conn = HTTPConnection(env['host'], port)
        conn.request('GET', '/selenium-server/driver/?cmd=shutDownSeleniumServer')
        #print conn.getresponse().read()

    puts('stopping selenium node instances')
    for port in range(int(config['selenium_node_first_port']), 
            int(config['selenium_node_first_port']) +
            int(config['selenium_node_instances'])):
         stop_instance(port)

### Hub
def deploy_selenium(config, env, ssh):
    puts('deploying the selenium grid hub')
    #upload(ssh, join('shelf', 'selenium'), env['appfolder'])
    wget(ssh, 'https://selenium.googlecode.com/files/%s' % config['selenium_jar']
        , env['appfolder'])

def start_hub(config, env, ssh):
    puts('starting selenium grid hub')
    run(ssh, 'cd %s ; nohup java -jar %s -role hub '
        '>/dev/null 2>&1 &' %
        (env['appfolder'], config['selenium_jar']))

def stop_hub(config):
    puts('stopping selenium grid hub')
    conn = HTTPConnection(
        config['selenium_hub_host'],
        config['selenium_hub_port'])
    conn.request('GET', '/lifecycle-manager/?action=shutdown')
