from selenium.webdriver.remote.webdriver import WebDriver
from selenium.webdriver.common.desired_capabilities import DesiredCapabilities
# from selenium.webdriver.support import expected_conditions as EC # for wait statements
from selenium.webdriver.common.by import By
from hamcrest import assert_that, equal_to, greater_than, is_
import random


class SupercarsDetailsTest():

    def __init__(self, log, thinktime, url, hub=None, webdriver=None):
        self.log = log
        self.thinktime = thinktime
        self.url = url
        self.hub = hub
        self.webdriver = webdriver

    def setup(self):
        if self.webdriver:
            from selenium import webdriver
            self.browser = getattr(webdriver, self.webdriver)()
        else:
            self.browser = WebDriver(command_executor=str(self.hub), 
                desired_capabilities=DesiredCapabilities.PHANTOMJS)

    def run(self):
        # test_url
        self.log('start_page', 'start')
        self.browser.get(self.url)
        assert_that(self.browser.title, is_('Angular Supercars'))

        # check that it has more than 10 elements
        entries = self.browser.find_elements(By.CSS_SELECTOR, "div#sidebar ul li a")
        assert_that(len(entries), greater_than(10))
        self.log('start_page', 'end')
        self.thinktime(5)

        self.log('details_page', 'start')
        random.choice(entries[:30]).click()

        # verify that we are on details page
        assert_that(len(self.browser.find_elements(By.ID, 'nameInput')), equal_to(1))
        self.log('details_page', 'end')
        # return 0

    def teardown(self):
        self.browser.quit()
