from kenji.query import V


def test_select(graph):
    for item in graph.select(V(1).knows):
        assert 2 <= item <= 4

    for item in graph.select(V().knows(1)):
        assert 2 <= item <= 3


def test_first(graph):
    assert graph.select(V(2).knows).first in (1, 5)


def test_intersection(graph):
    assert list(graph.select(V(1).knows)
                     .intersection(V().knows(1))) == [2, 3]
    assert list(graph.select(V(2).knows)
                     .intersection(V().knows(2))) == [1]


def test_union(graph):
    assert list(graph.select(V().knows(2)).union(V().knows(1))) == [1, 2, 3]
    assert list(graph.select(V(1).knows).union(V(2).knows)) == [1, 2, 3, 4, 5]


def test_difference(graph):
    assert list(graph.select(V(1).knows).difference(V().knows(1))) == [4]


def test_count_and_limit(graph):
    assert graph.select(V(1).knows).count == 3
    assert len(list(graph.select(V(1).knows).limit(2))) == 2
