from kenji import Graph, V
from contextlib import closing
from sqlite3 import ProgrammingError


def test_store():
    graph = Graph(graphs=['knows'])
    graph.store(V(1).knows(10))
    assert graph.exists(V(1).knows(10))


def test_unsafe():
    graph = Graph(unsafe=True)
    cursor = graph.db.execute('PRAGMA synchronous')
    with closing(cursor):
        assert not next(cursor)[0]


def test_delete(graph):
    graph.delete(V().knows(2))
    assert 2 not in list(graph.select(V(1).knows))

    graph.delete(V(1).knows)
    assert not list(graph.select(V(1).knows))

    graph.store(V(1).knows(2))
    graph.delete(V().knows)
    assert not list(graph.select(V(1).knows))


def test_close(graph):
    graph.close()
    assert graph.closed
    try:
        graph.db.execute('SELECT * FROM knows;')
        assert False, 'connection is not closed!'
    except ProgrammingError:
        pass


def test_graph_relation(graph):
    assert graph.relation_between('person', V(1)(2)) == ['knows', 'likes']
    assert graph.relation_between('person', V(0)(2)) == []


def test_graph_exists(graph):
    assert graph.exists(V(1).knows(2))
    assert not graph.exists(V(1).knows(10))
