from itertools import chain
from pytest import fixture
from kenji import Graph, V


@fixture
def graph():
    graph = Graph(graphs=['knows', 'likes'],
                  mapping={'person': ['knows', 'likes']})

    c = chain(
        (V(1).knows(i) for i in range(2, 5)),
        (V(i).knows(1) for i in range(2, 4)),
        [
            V(2).knows(5),
            V(1).likes(2)
        ]
    )

    for x in c:
        graph.store(x)
    return graph
