from kenji import V
from threading import Thread
from sqlite3 import OperationalError


def test_transactional(graph):
    with graph.transaction() as tr:
        tr.store(V(1).knows(5))
        tr.store(V(1).knows(6))
        tr.delete(V(1).knows(2))

    assert graph.exists(V(1).knows(5))
    assert graph.exists(V(1).knows(6))
    assert not graph.exists(V(1).knows(2))


def test_abort(graph):
    with graph.transaction() as tr:
        tr.store(V(1).knows(5))
        tr.abort()
        tr.store(V(1).knows(6))

    assert not graph.exists(V(1).knows(5))
    assert not graph.exists(V(1).knows(6))


def test_atomicity(graph):
    try:
        with graph.transaction() as tr:
            tr.store(V(1).knows(5))
            tr.store(V(1).knows(6))
            tr.store(V(1).follows(2))
    except OperationalError:
        assert not graph.exists(V(1).knows(5))
        assert not graph.exists(V(1).knows(6))
