from kenji import Graph
from kenji.query import V


def test_select(graph):
    for item in graph.select(V(1).knows):
        assert 2 <= item <= 4

    for item in graph.select(V().knows(1)):
        assert 2 <= item <= 3


def test_first(graph):
    assert graph.select(V(2).knows).first in (1, 5)
    assert 2 <= graph.select(V(1).knows).first <= 4
    assert not graph.select(V(10).knows).first


def test_intersection(graph):
    assert list(graph.select(V(1).knows)
                     .intersection(V().knows(1))) == [2, 3]
    assert list(graph.select(V(2).knows)
                     .intersection(V().knows(2))) == [1]


def test_traverse_multi_table():
    graph = Graph(graphs=['knows', 'likes'])
    with graph.transaction() as tr:
        tr.store(V(1).knows(2))
        tr.store(V(2).likes(3))
        tr.store(V(2).likes(4))
        tr.store(V(3).knows(1))

    assert list(graph.select(V(1).knows).traverse('likes')) == [3, 4]
    assert list(graph.select(V(2).likes).traverse('knows')) == [1]


def test_traverse(graph):
    assert list(graph.select(V(1).knows).traverse('knows')) == [1, 5, 1]
    assert set(graph.select(V(1).knows)
                    .traverse('knows')
                    .traverse('knows')) == set((2,3,4))


def test_union(graph):
    assert list(graph.select(V().knows(2)).union(V().knows(1))) == [1, 2, 3]
    assert list(graph.select(V(1).knows).union(V(2).knows)) == [1, 2, 3, 4, 5]


def test_difference(graph):
    assert list(graph.select(V(1).knows).difference(V().knows(1))) == [4]
    assert list(graph.select(V(1).knows).difference(V(2).knows)) == [2, 3, 4]


def test_count(graph):
    assert graph.select(V(1).knows).count == 3
    assert graph.select(V(2).knows).count == 2


def test_limit(graph):
    assert len(list(graph.select(V(1).knows).limit(2))) == 2
    assert len(list(graph.select(V(2).knows).limit(1))) == 1


def test_v_special():
    v = V(1) >= V(2)
    assert v.src == 1
    assert v.dst == 2

    v = V(3) <= V(2)
    assert v.src == 2
    assert v.dst == 3

    v = V(3, 'follows', 2)
    assert v.src == 3 and v.dst == 2
    assert v.relation == 'follows'


def test_v_repr():
    assert repr(V(1).knows(2)) == '(1)-[:knows]->(2)'
    assert repr(V().knows(2))  == '(*)-[:knows]->(2)'
    assert repr(V(1).knows)    == '(1)-[:knows]->(*)'
    assert repr(V().knows)     == '(*)-[:knows]->(*)'
    assert repr(V()) == '(*)-[*]->(*)'
