"""
Kenji is an SQLite-backed graph datastore that
is similar in design and scope to Twitter's
FlockDB.

.. codeauthor:: Eugene Eeo <packwolf58@gmail.com>

Usage example:

    >>> g = Graph(graphs=['follows'])
    >>> g.store(V(1).knows(2))
    >>> list(g.select(V(1).knows))
    [1]
    >>> g.store(V(2).knows(1))
    >>> g.select(V(1).knows).intersection(V().knows(1)).first
    2
"""

from kenji.query import V
from kenji.graph import Graph
