/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.InstructionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClauseInfo
implements InstructionInfo {
    private Clause clause;
    private Container container;
    private NamespaceResolver nsResolver;

    public ClauseInfo(Clause clause, Container container) {
        this.clause = clause;
        this.container = container;
    }

    @Override
    public int getConstructType() {
        return 3000 + this.clause.getClauseKey();
    }

    @Override
    public StructuredQName getObjectName() {
        LocalVariableBinding[] vars = this.clause.getRangeVariables();
        if (vars != null && vars.length > 0) {
            return vars[0].getVariableQName();
        }
        return null;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsResolver;
    }

    public void setNamespaceResolver(NamespaceResolver nsResolver) {
        this.nsResolver = nsResolver;
    }

    @Override
    public String getSystemId() {
        return this.container.getLocationProvider().getSystemId(this.clause.getLocationId());
    }

    @Override
    public int getLineNumber() {
        return this.container.getLocationProvider().getLineNumber(this.clause.getLocationId());
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public Iterator<String> getProperties() {
        List ls = Collections.emptyList();
        return ls.iterator();
    }

    @Override
    public String getSystemId(long locationId) {
        return this.getSystemId();
    }

    @Override
    public int getLineNumber(long locationId) {
        return this.getLineNumber();
    }

    @Override
    public int getColumnNumber(long locationId) {
        return -1;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }
}

