/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Available;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class ElementAvailable
extends Available
implements CallableExpression {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        String lexicalQName = ((Literal)this.argument[0]).getValue().getStringValue();
        StaticContext env = visitor.getStaticContext();
        boolean b = ((XSLTStaticContext)env).isElementAvailable(lexicalQName);
        return Literal.makeLiteral(BooleanValue.get(b));
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue av1 = (AtomicValue)this.argument[0].evaluateItem(context);
        StringValue nameValue = (StringValue)av1;
        String lexicalName = nameValue.getStringValue();
        boolean b = this.isElementAvailable(lexicalName, context);
        return BooleanValue.get(b);
    }

    private boolean isElementAvailable(String lexicalName, XPathContext context) throws XPathException {
        StructuredQName qName;
        try {
            if (lexicalName.indexOf(58) < 0) {
                String uri = this.nsContext.getURIForPrefix("", true);
                qName = new StructuredQName("", uri, lexicalName);
            } else {
                qName = StructuredQName.fromLexicalQName(lexicalName, false, context.getConfiguration().getNameChecker(), this.nsContext);
            }
        }
        catch (XPathException e) {
            e.setErrorCode("XTDE1440");
            e.setLocator(this);
            e.setXPathContext(context);
            throw e;
        }
        try {
            PreparedStylesheet pss = (PreparedStylesheet)context.getController().getExecutable();
            return pss.getStyleNodeFactory().isElementAvailable(qName.getURI(), qName.getLocalPart());
        }
        catch (Exception err) {
            return false;
        }
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        String lexicalQName = arguments[0].next().getStringValue();
        boolean b = this.isElementAvailable(lexicalQName, context);
        return SingletonIterator.makeIterator(BooleanValue.get(b));
    }
}

