/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StandardEntityResolver
implements EntityResolver {
    private static StandardEntityResolver THE_INSTANCE = new StandardEntityResolver();
    private static HashMap<String, String> publicIds = new HashMap(30);
    private static HashMap<String, String> systemIds = new HashMap(30);
    public boolean tracing = false;
    public PrintStream traceDestination = null;

    public static StandardEntityResolver getInstance() {
        return THE_INSTANCE;
    }

    public static void register(String publicId, String systemId, String fileName) {
        if (publicId != null) {
            publicIds.put(publicId, fileName);
        }
        if (systemId != null) {
            systemIds.put(systemId, fileName);
        }
    }

    public void setConfiguration(Configuration config) {
        this.tracing = config.isTiming();
        this.traceDestination = config.getStandardErrorOutput();
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String fileName = publicIds.get(publicId);
        if (fileName != null) {
            return this.fetch(fileName);
        }
        fileName = systemIds.get(systemId);
        if (fileName != null) {
            return this.fetch(fileName);
        }
        return null;
    }

    private InputSource fetch(String filename) {
        if (this.tracing) {
            if (this.traceDestination == null) {
                this.traceDestination = System.err;
            }
            this.traceDestination.println("Fetching Saxon copy of " + filename);
        }
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        InputStream in = Configuration.locateResource(filename, messages, classLoaders);
        if (this.tracing) {
            for (String s : messages) {
                this.traceDestination.println(s);
            }
        }
        if (in == null) {
            return null;
        }
        return new InputSource(in);
    }

    static {
        StandardEntityResolver.register("-//W3C//ENTITIES Latin 1 for XHTML//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent", "w3c/xhtml-lat1.ent");
        StandardEntityResolver.register("-//W3C//ENTITIES Symbols for XHTML//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent", "w3c/xhtml-symbol.ent");
        StandardEntityResolver.register("-//W3C//ENTITIES Special for XHTML//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent", "w3c/xhtml-special.ent");
        StandardEntityResolver.register("-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", "w3c/xhtml10/xhtml1-transitional.dtd");
        StandardEntityResolver.register("-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", "w3c/xhtml10/xhtml1-strict.dtd");
        StandardEntityResolver.register("-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd", "w3c/xhtml10/xhtml1-frameset.dtd");
        StandardEntityResolver.register("-//W3C//DTD XHTML Basic 1.0//EN", "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd", "w3c/xhtml10/xhtml-basic10.dtd");
        StandardEntityResolver.register("-//W3C//DTD XHTML 1.1//EN", "http://www.w3.org/MarkUp/DTD/xhtml11.dtd", "w3c/xhtml11/xhtml11.dtd");
        StandardEntityResolver.register("-//W3C//DTD XHTML Basic 1.1//EN", "http://www.w3.org/MarkUp/DTD/xhtml-basic11.dtd", "w3c/xhtml11/xhtml-basic11.dtd");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Access Element 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-access-1.mod", "w3c/xhtml11/xhtml-access-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Access Attribute Qnames 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-access-qname-1.mod", "w3c/xhtml11/xhtml-access-qname-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Java Applets 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-applet-1.mod", "w3c/xhtml11/xhtml-applet-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Base Architecture 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-arch-1.mod", "w3c/xhtml11/xhtml-arch-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Common Attributes 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-attribs-1.mod", "w3c/xhtml11/xhtml-attribs-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Base Element 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-base-1.mod", "w3c/xhtml11/xhtml-base-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Basic Forms 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-basic-form-1.mod", "w3c/xhtml11/xhtml-basic-form-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Basic Tables 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-basic-table-1.mod", "w3c/xhtml11/xhtml-basic-table-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Basic 1.0 Document Model 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-basic10-model-1.mod", "w3c/xhtml11/xhtml-basic10-model-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Basic 1.1 Document Model 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-basic11-model-1.mod", "w3c/xhtml11/xhtml-basic11-model-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML BDO Element 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-bdo-1.mod", "w3c/xhtml11/xhtml-bdo-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Block Phrasal 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-blkphras-1.mod", "w3c/xhtml11/xhtml-blkphras-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Block Presentation 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-blkpres-1.mod", "w3c/xhtml11/xhtml-blkpres-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Block Structural 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-blkstruct-1.mod", "w3c/xhtml11/xhtml-blkstruct-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Character Entities 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-charent-1.mod", "w3c/xhtml11/xhtml-charent-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Client-side Image Maps 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-csismap-1.mod", "w3c/xhtml11/xhtml-csismap-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Datatypes 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-datatypes-1.mod", "w3c/xhtml11/xhtml-datatypes-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Editing Markup 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-edit-1.mod", "w3c/xhtml11/xhtml-edit-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Intrinsic Events 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-events-1.mod", "w3c/xhtml11/xhtml-events-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Forms 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-form-1.mod", "w3c/xhtml11/xhtml-form-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Frames 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-frames-1.mod", "w3c/xhtml11/xhtml-frames-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Modular Framework 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-framework-1.mod", "w3c/xhtml11/xhtml-framework-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML HyperAttributes 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-hyperAttributes-1.mod", "w3c/xhtml11/xhtml-hyperAttributes-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Hypertext 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-hypertext-1.mod", "w3c/xhtml11/xhtml-hypertext-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Inline Frame Element 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-iframe-1.mod", "w3c/xhtml11/xhtml-iframe-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Images 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-image-1.mod", "w3c/xhtml11/xhtml-image-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Inline Phrasal 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-inlphras-1.mod", "w3c/xhtml11/xhtml-inlphras-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Inline Presentation 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-inlpres-1.mod", "xhtml11/xhtml-inlpres-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Inline Structural 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-inlstruct-1.mod", "w3c/xhtml11/xhtml-inlstruct-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Inline Style 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-inlstyle-1.mod", "w3c/xhtml11/xhtml-inlstyle-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Inputmode 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-inputmode-1.mod", "w3c/xhtml11/xhtml-inputmode-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Legacy Markup 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-legacy-1.mod", "w3c/xhtml11/xhtml-legacy-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Legacy Redeclarations 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-legacy-redecl-1.mod", "w3c/xhtml11/xhtml-legacy-redecl-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Link Element 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-link-1.mod", "w3c/xhtml11/xhtml-link-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Lists 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-list-1.mod", "w3c/xhtml11/xhtml-list-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Metainformation 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-meta-1.mod", "w3c/xhtml11/xhtml-meta-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Metainformation 2.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-meta-2.mod", "w3c/xhtml11/xhtml-meta-2.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML MetaAttributes 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-metaAttributes-1.mod", "w3c/xhtml11/xhtml-metaAttributes-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Name Identifier 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-nameident-1.mod", "w3c/xhtml11/xhtml-nameident-1.mod");
        StandardEntityResolver.register("-//W3C//NOTATIONS XHTML Notations 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-notations-1.mod", "w3c/xhtml11/xhtml-notations-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Embedded Object 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-object-1.mod", "w3c/xhtml11/xhtml-object-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Param Element 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-param-1.mod", "w3c/xhtml11/xhtml-param-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Presentation 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-pres-1.mod", "w3c/xhtml11/xhtml-pres-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML-Print 1.0 Document Model 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-print10-model-1.mod", "w3c/xhtml11/xhtml-print10-model-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Qualified Names 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-qname-1.mod", "w3c/xhtml11/xhtml-qname-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML+RDFa Document Model 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-rdfa-model-1.mod", "w3c/xhtml11/xhtml-rdfa-model-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML RDFa Attribute Qnames 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-rdfa-qname-1.mod", "w3c/xhtml11/xhtml-rdfa-qname-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Role Attribute 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-role-1.mod", "w3c/xhtml11/xhtml-role-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML Role Attribute Qnames 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-role-qname-1.mod", "w3c/xhtml11/xhtml-role-qname-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Ruby 1.0//EN", "http://www.w3.org/TR/ruby/xhtml-ruby-1.mod", "w3c/xhtml11/xhtml-ruby-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Scripting 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-script-1.mod", "w3c/xhtml11/xhtml-script-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Server-side Image Maps 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-ssismap-1.mod", "w3c/xhtml11/xhtml-ssismap-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Document Structure 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-struct-1.mod", "w3c/xhtml11/xhtml-struct-1.mod");
        StandardEntityResolver.register("-//W3C//DTD XHTML Style Sheets 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-style-1.mod", "w3c/xhtml11/xhtml-style-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Tables 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-table-1.mod", "w3c/xhtml11/xhtml-table-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Target 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-target-1.mod", "w3c/xhtml11/xhtml-target-1.mod");
        StandardEntityResolver.register("-//W3C//ELEMENTS XHTML Text 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml-text-1.mod", "w3c/xhtml11/xhtml-text-1.mod");
        StandardEntityResolver.register("-//W3C//ENTITIES XHTML 1.1 Document Model 1.0//EN", "http://www.w3.org/MarkUp/DTD/xhtml11-model-1.mod", "w3c/xhtml11/xhtml11-model-1.mod");
        StandardEntityResolver.register("-//W3C//MathML 1.0//EN", "http://www.w3.org/Math/DTD/mathml1/mathml.dtd", "w3c/mathml/mathml1/mathml.dtd");
        StandardEntityResolver.register("-//W3C//DTD MathML 2.0//EN", "http://www.w3.org/Math/DTD/mathml2/mathml2.dtd", "w3c/mathml/mathml2/mathml2.dtd");
        StandardEntityResolver.register("-//W3C//DTD MathML 3.0//EN", "http://www.w3.org/Math/DTD/mathml3/mathml3.dtd", "w3c/mathml/mathml3/mathml3.dtd");
        StandardEntityResolver.register("-//W3C//DTD SVG 1.0//EN", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd", "w3c/svg10/svg10.dtd");
        StandardEntityResolver.register("-//W3C//DTD SVG 1.1//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", "w3c/svg11/svg11.dtd");
        StandardEntityResolver.register("-//W3C//DTD SVG 1.1 Tiny//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd", "w3c/svg11/svg11-tiny.dtd");
        StandardEntityResolver.register("-//W3C//DTD SVG 1.1 Basic//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-basic.dtd", "w3c/svg11/svg11-basic.dtd");
        StandardEntityResolver.register("-//XML-DEV//ENTITIES RDDL Document Model 1.0//EN", "http://www.rddl.org/xhtml-rddl-model-1.mod", "w3c/rddl/xhtml-rddl-model-1.mod");
        StandardEntityResolver.register("-//XML-DEV//DTD XHTML RDDL 1.0//EN", "http://www.rddl.org/rddl-xhtml.dtd", "w3c/rddl/rddl-xhtml.dtd");
        StandardEntityResolver.register("-//XML-DEV//ENTITIES RDDL QName Module 1.0//EN", "http://www.rddl.org/rddl-qname-1.mod", "rddl/rddl-qname-1.mod");
        StandardEntityResolver.register("-//XML-DEV//ENTITIES RDDL Resource Module 1.0//EN", "http://www.rddl.org/rddl-resource-1.mod", "rddl/rddl-resource-1.mod");
        StandardEntityResolver.register("-//W3C//DTD Specification V2.10//EN", "http://www.w3.org/2002/xmlspec/dtd/2.10/xmlspec.dtd", "w3c/xmlspec/xmlspec.dtd");
        StandardEntityResolver.register("-//W3C//DTD XMLSCHEMA 200102//EN", "http://www.w3.org/2001/XMLSchema.dtd", "w3c/xmlschema/XMLSchema.dtd");
    }
}

