from operator import add, sub, mul, floordiv
from kessel import *


wspace = optional(word(" \n\r\t"))
operator = mapf(one_of(*"+-*/"))({
    "+": add,
    "-": sub,
    "*": mul,
    "/": floordiv
}.__getitem__)
number = mapf(word("0123456789"))(int)


@gen_parser
def rpn():
    """
    This is a really simple Reverse Polish Notation parser that also does
    evaluation.
    """

    stack = []

    while True:
        # Parse any preceding whitespace.
        yield wspace

        # Try parse an operator first.
        try:
            op = yield operator
        except Unexpected:
            pass
        else:
            stack.append(op(stack.pop(), stack.pop()))
            continue

        # If that fails, try parse a number.
        try:
            n = yield number
        except Unexpected:
            pass
        else:
            stack.append(n)
            continue

        # Otherwise, this has to be the end of input.
        yield eof
        break

    return stack


while True:
    try:
        stack = rpn().parse(input("> "))
    except EOFError:
        break
    except Exception as e:
        print("{}: {}".format(e.__class__.__name__, e))
    else:
        print("stack:", stack)
