"""
String-level parsers.
"""

__all__ = ["literal", "word"]

from .parser import single, Parser
from .combinators import sequence, choice, many, try_


class literal(Parser):
    """
    Parse a string of characters that matches the given value exactly.
    """

    def __init__(self, value):
        self.value = value

    def do_parse(self, state):
        return "".join(try_(sequence(*[single(x)
                                       for x in self.value])).do_parse(state))

    def __repr__(self):
        return "literal({value!r})".format(**self.__dict__)


class word(Parser):
    """
    Parse a string of characters using the set of characters given.
    """

    def __init__(self, chars):
        self.chars = chars

    def do_parse(self, state):
        s = choice(*[single(x) for x in self.chars])

        first = s.do_parse(state)
        rest = many(s).do_parse(state)

        return first + "".join(rest)

    def __repr__(self):
        return "word({chars!r})".format(**self.__dict__)
