from setuptools import setup, find_packages
import kessel


setup(
    name=kessel.__name__,
    version=kessel.__version__,
    description="""
Kessel is a parser library for Python that supports parsing a wide variety of
grammars, from simple LL(1) grammars to complex, context-sensitive grammars
with minimal hassle.
""",
    author="Tony Young",
    author_email="tony@rfw.name",
    url="http://kessel.rtfd.org",
    license="MIT",
    packages=find_packages("kessel"),
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Topic :: Text Processing"
    ],
    install_requires=["setuptools"],
    zip_safe=True
)
