from kessel import parser, string, combinators


def test_literal():
    assert string.literal("hello").parse("hello") == "hello"


def test_literal_repr():
    assert repr(string.literal("hello")) == "literal('hello')"


def test_literal_choice():
    assert combinators.choice(string.literal("hallo"),
                              string.literal("hello")).parse("hello") == "hello"


def test_bad_literal():
    try:
        string.literal("hello").parse("hallo")
    except parser.Unexpected as e:
        if e.expected != frozenset(["e"]) or e.actual != "a" or e.index != 1:
            raise
    else:
        assert False, "should have thrown exception"


def test_word():
    assert string.word("0123456789").parse("100") == "100"


def test_bad_word():
    assert string.word("0123456789").parse("100h") == "100"


def test_word_repr():
    assert repr(string.word("0123456789")) == "word('0123456789')"
