"""
KForge www (project home) Plugin.

Enabling this plugin creates a project web directory (that is a directory on
the file system the contents of which are displayed at the project's url on the
KForge site). If the dav plugin is enabled then this directory will be
accessible via dav.

## Installation ##

1. Dependencies. There are no dependencies beyond those required for KForge.

2. KForge config file. You do not need to add anything to the KForge config
   file.
"""
import os
import shutil

import kforge.plugin.base
import kforge.url

class Plugin(kforge.plugin.base.SingleServicePlugin):
    
    def __init__(self, domainObject):
        super(Plugin, self).__init__(domainObject)
    
    def onServiceCreate(self, service):
        """
        For www since a single service plugin only want the plugin directory
        and do not need a service subdirectory
        """
        if service and service.plugin and service.plugin.name == self.domainObject.name:
            self.ensureProjectPluginDirectoryExists(service)
    
    def onServicePurge(self, service):
        if service and service.plugin and service.plugin.name == self.domainObject.name:
            projectPluginPath = self.paths.getProjectPluginPath(service.project, service.plugin)
            if os.path.exists(projectPluginPath):
                shutil.rmtree(projectPluginPath)
    
    def getApacheConfig(self, service):
        """
        Note: allow access to everyone -- even guest
        """
        fsPath = self.paths.getProjectPluginPath(service.project, service.plugin)
        result = 'Alias %(urlPath)s ' + fsPath
        return result

