# -*- coding: utf-8 -*-

from __future__ import with_statement

import os
import tempfile
import pwd
import grp
import gzip
import shutil

__all__ = ['file_get_contents', 'file_put_contents',
           'tmpfile', 'tmpdir', 'rmtree', 'unlink',
           'recursive_chown', 'file_zip',
           'zipfile_get_contents']


def file_get_contents(filename):
    """Returns string content from filename"""

    with open(filename) as f:
        s = f.read()
    return s


def file_put_contents(filename, string):
    """Write string to filename."""

    with open(filename, 'w') as f:
        f.write(string)


def mkdir(dirs, recursive=False, mode=None):
    if isinstance(dirs, basestring):
        dirs = [dirs]
    args = () if mode is None else (mode, )
    for d in dirs:
        if recursive:
            os.makedirs(d, *args)
        else:
            os.mkdir(d, *args)


def touch(fname):
    """Create file if not existent

    Note that it doesn't change access time.

    """
    open(fname, 'a').close()


def tmpfile(content=None):
    fp, _tmpfile = tempfile.mkstemp()
    os.close(fp)
    if content is not None:
        file_put_contents(_tmpfile, content)
    return _tmpfile

## importing these KIDS methods from other modules
tmpdir = tempfile.mkdtemp
rmtree = shutil.rmtree


def unlink(filename, force=False):
    try:
        os.unlink(filename)
    except OSError, e:
        # catch file does not exists
        if not force or not e.errno is 2:
            raise


def chown(path, user, group=None, recursive=False):
    """Retrieve uid of user then change ownership of the path
    """

    if group is None:
        group = user

    uid = pwd.getpwnam(user).pw_uid
    gid = grp.getgrnam(group).gr_gid

    if not recursive:
        os.chown(path, uid, gid)
    else:
        for root, _dirs, files in os.walk(path):
            os.chown(root, uid, gid)
            for cfile in files:
                os.chown(os.path.join(root, cfile), uid, gid)


def file_zip(filename, destination=''):
    """zip a file and put it in destination dir"""
    dest = destination if destination else (filename + '.gz')

    out = gzip.open(dest, 'wb')
    try:
        out.write(file_get_contents(filename))
    finally:
        out.close()


def zipfile_get_contents(filename):
    out = gzip.open(filename, 'rb')
    try:
        return out.read()
    finally:
        out.close()
