from django.utils.translation import ugettext_lazy as _
from kii.app import core, menu


class App(core.App):
    name = "kii_blog"
    label = "blog"
    verbose_name = "Blog"
    urls = ".urls"
    user_access = True
    
    def ready(self):
        super(App, self).ready()
        self.menu = menu.MenuNode(
            route="kii:blog:index", 
            label=_("blog"),
            icon="fi-pencil",
            children = [
                menu.MenuNode(
                    route="kii:blog:entry:create",
                    label=_("create")
                )
            ]           
        )