class KoalityConfigTemplateGenerator(object):
	def __init__(self, language_generator, setup_generator):
		self.language_generator = language_generator
		self.setup_generator = setup_generator

	def generate(self):
		return [
			{'languages' : self.language_generator.generate()},
			{'setup': self.setup_generator.generate()},
			{
				'compile': {
					'scripts': [
						{
							'compile script template': {
								'path': '.',
								'script': [
									'false "\n\n' + '\n'.join([
										'\x1b[1;31mThis is an autogenerated template',
										'\x1b[0mYou need to complete this section with necessary compilation scripts',
										'\x1b[0mThese scripts will be run before testing and on every machine',
										'\x1b[0mDocumentation on test scripts can be found at https://koalitycode.com/documentation?view=yamlCompile',
										'',
										'\x1b[1;31mIn the generated koality.yml file, we\'ve attempted to infer a valid compile section from your repo structure',
										'\x1b[1;31mThis inferred compile section may not be correct for your code',
										'\x1b[0mIf you\'d like to try it, our inferred factory is in the comments above the compile section in your koaliy.yml',
										'\x1b[0mNOTE: Not every repository needs a compile section, so we may have inferred an empty section',
										'',
										'"'
									]),
								]
							}
						}
					]
				}
			},
			{
				'test': {
					'scripts': [
						{
							'test script template': {
								'path': '.',
								'script': [
									'false "\n\n' + '\n'.join([
										'\x1b[1;31mThis is an autogenerated template',
										'\x1b[0mYou need to complete this section with a test script (if necessary)',
										'\x1b[0mEach manually entered test script is a parallelizable unit',
										'\x1b[0mDocumentation on test scripts can be found at https://koalitycode.com/documentation?view=yamlTest',
										'',
										'"'
									]),
								],
								'timeout': 10
							}
						},
					],
					'factories': [
						{
							'factory template': {
								'path': '.',
								'script': [
									'echo "\x1b[1;31mThis is an autogenerated template"',
									'echo "You need to complete this section with a test factory for your code (if needed)"',
									'echo "\x1b[0mEach factory generated test script is a parallelizable unit"',
									'echo "Documentation on factories can be found at https://koalitycode.com/documentation?view=yamlTest"',
									'echo ""',
									'echo "\x1b[1;31mIn the generated koality.yml file, we\'ve attempted to infer a valid factory from your repo structure"',
									'echo "\x1b[1;31mThis inferred factory section may not be correct for your code"',
									'echo "If you\'d like to try it, our inferred factory is in the comments above the factory section in your koality.yml"',
									'exit 1'
								]
							}
						},
					],
					'machines': 8
				}
			}
		]
