# -*- coding: utf-8 -*-

from tornado.tcpserver import TCPServer
from tornado.ioloop import IOLoop

from .callbacks_mixin import AppCallBacksMixin
from .connection import Connection
from vals import logger


class Kola(TCPServer, AppCallBacksMixin):
    """
    tcp server
    """

    debug = False
    conn_class = None
    blueprints = None
    got_first_request = False

    def __init__(self, conn_class=None, **kwargs):
        TCPServer.__init__(self, **kwargs)
        AppCallBacksMixin.__init__(self)
        self.conn_class = conn_class or Connection

        self.blueprints = dict()
        self._configure_exc_handler()

    def handle_stream(self, stream, address):
        self.conn_class(self, stream, address)

    def run(self, host, port):
        self.listen(port, host)
        IOLoop.instance().start()

    def register_blueprint(self, blueprint):
        blueprint.register2app(self)

    def _configure_exc_handler(self):
        """
        因为tornado的默认handler的log不一定会被配置
        """
        def exc_handler(callback):
            logger.error("Exception in callback %r", callback, exc_info=True)

        IOLoop.instance().handle_callback_exception = exc_handler
