# -*- coding: utf-8 -*-

import logging

from tornado.tcpserver import TCPServer
from tornado.ioloop import IOLoop

from .callbacks_mixin import AppCallBacksMixin
from .connection import Connection


class Kola(TCPServer, AppCallBacksMixin):
    """
    tcp server
    """

    debug = False
    conn_class = None
    blueprints = None

    def __init__(self, conn_class=None, **kwargs):
        TCPServer.__init__(self, **kwargs)
        AppCallBacksMixin.__init__(self)
        self.conn_class = conn_class or Connection

        self.blueprints = dict()

    def handle_stream(self, stream, address):
        self.conn_class(self, stream, address)

    def run(self, host, port):
        self.listen(port, host)
        IOLoop.instance().start()

    def register_blueprint(self, blueprint):
        blueprint.register2app(self)
