# -*- coding: utf-8 -*-

import functools
import time


class RoutesMixin(object):
    """
    专门做路由管理
    """

    rule_map = None

    def __init__(self):
        self.rule_map = dict()

    def add_route_rule(self, endpoint=None, view_func=None, **options):
        assert view_func is not None, 'expected view func if endpoint is not provided.'

        endpoint = endpoint or view_func.__name__
        if endpoint in self.rule_map and view_func != self.rule_map[endpoint]:
            raise Exception, 'repeat view_func for endpoint: %(endpoint)s, old_view_func:%(old_view_func)s, new_view_func: %(new_view_func)s' % dict(
                endpoint=endpoint,
                old_view_func=self.rule_map[endpoint],
                new_view_func=view_func,
                )

        self.rule_map[endpoint] = view_func

    def route(self, **options):
        def decorator(f):
            endpoint = options.pop('endpoint', None)
            self.add_route_rule(endpoint, f, **options)
            return f
        return decorator

    def get_route_view_func(self, endpoint):
        return self.rule_map.get(endpoint)


class AppCallBacksMixin(RoutesMixin):
    create_conn_func_list = None
    before_first_request_func_list = None
    before_request_func_list = None
    after_request_func_list = None
    before_response_func_list = None
    close_conn_func_list = None

    def __init__(self):
        super(AppCallBacksMixin, self).__init__()
        self.create_conn_func_list = []
        self.before_first_request_func_list = []
        self.before_request_func_list = []
        self.after_request_func_list = []
        self.before_response_func_list = []
        self.close_conn_func_list = []

    def create_conn(self, f):
        """
        连接建立成功后
        f(conn)
        """
        self.create_conn_func_list.append(f)
        return f

    def before_first_request(self, f):
        """
        第一个请求，请求解析为json成功后
        f(request)
        """
        self.before_first_request_func_list.append(f)
        return f

    def before_request(self, f):
        """
        请求解析为json成功后
        f(request)
        """
        self.before_request_func_list.append(f)
        return f

    def after_request(self, f):
        """
        执行完route对应的view_func后
        f(request)
        """
        self.after_request_func_list.append(f)
        return f

    def before_response(self, f):
        """
        在 stream.write 之前，传入encode之后的data
        f(response)
        """
        self.before_response_func_list.append(f)
        return f

    def close_conn(self, f):
        """
        连接close之后
        f(conn)
        """
        self.close_conn_func_list.append(f)
        return f


class BlueprintCallBacksMixin(RoutesMixin):
    before_request_func_list = None
    after_request_func_list = None
    create_app_conn_func_list = None
    before_app_first_request_func_list = None
    before_app_request_func_list = None
    after_app_request_func_list = None
    before_app_response_func_list = None
    close_app_conn_func_list = None

    def __init__(self):
        super(BlueprintCallBacksMixin, self).__init__()
        self.before_request_func_list = []
        self.after_request_func_list = []
        self.create_app_conn_func_list = []
        self.before_app_first_request_func_list = []
        self.before_app_request_func_list = []
        self.after_app_request_func_list = []
        self.before_app_response_func_list = []
        self.close_app_conn_func_list = []

    def before_request(self, f):
        """
        请求解析为json成功后
        f(request)
        """
        self.before_request_func_list.append(f)
        return f

    def after_request(self, f):
        """
        执行完route对应的view_func后
        f(request)
        """
        self.after_request_func_list.append(f)
        return f

    def create_app_conn(self, f):
        """
        连接建立成功后
        f(conn)
        """
        self.create_app_conn_func_list.append(f)
        return f

    def before_app_first_request(self, f):
        """
        第一次请求，请求解析为json成功后
        f(request)
        """
        self.before_app_first_request_func_list.append(f)
        return f

    def before_app_request(self, f):
        """
        请求解析为json成功后
        f(request)
        """
        self.before_app_request_func_list.append(f)
        return f

    def after_app_request(self, f):
        """
        执行完route对应的view_func后
        f(request)
        """
        self.after_app_request_func_list.append(f)
        return f

    def before_app_response(self, f):
        """
        在 stream.write 之前，传入encode之后的data
        f(response)
        """
        self.before_app_response_func_list.append(f)
        return f

    def close_app_conn(self, f):
        """
        连接close之后
        f(conn)
        """
        self.close_app_conn_func_list.append(f)
        return f
