# -*- coding: utf-8 -*-

from .callbacks_mixin import AppCallBacksMixin
from .connection import Connection
from .utils import safe_call
from .vals import logger


class Kola(AppCallBacksMixin):
    """
    tcp server
    """

    debug = False
    conn_class = None
    blueprints = None
    got_first_request = False

    def __init__(self, conn_class=None):
        AppCallBacksMixin.__init__(self)
        self.conn_class = conn_class or Connection
        self.blueprints = dict()

    def register_blueprint(self, blueprint):
        blueprint.register2app(self)
