# -*- coding: utf-8 -*-

import json
from .log import logger
from . import constants


class Request(object):
    """
    请求
    """

    conn = None
    raw_data = None
    values = None
    is_valid = False

    def __init__(self, conn, raw_data):
        # 为了书写方便
        self.finish = conn.finish
        self.close = conn.close

        self.conn = conn
        self.raw_data = raw_data
        self.is_valid = self._parse_raw_data()

    def _parse_raw_data(self):
        try:
            self.values = json.loads(self.raw_data)
        except Exception, e:
            logger.error('parse raw_data fail. e: %s, request: %s', e, self)
            return False

        if not isinstance(self.values, dict):
            logger.error('values is not dict. request: %s', self)
            return False

        if not self.values.get(constants.ENDPOINT_NAME):
            logger.error('endpoint is not in values. request: %s', self)
            return False

        return True

    def write(self, data, *args, **kwargs):
        """
        要自动把endpoint和sn写入
        """
        if isinstance(data, dict):
            new_data = {
                constants.ENDPOINT_NAME: self.endpoint,
            }

            if self.sn is not None:
                new_data[constants.SN_NAME] = self.sn

            # 用户传的优先级是最高的，可以覆盖默认的
            new_data.update(data)
        else:
            new_data = data

        return self.conn.write(new_data, *args, **kwargs)

    @property
    def app(self):
        return self.conn.app

    @property
    def address(self):
        return self.conn.address

    @property
    def endpoint(self):
        try:
            return self.values.get(constants.ENDPOINT_NAME)
        except:
            return None

    @property
    def sn(self):
        try:
            return self.values.get(constants.SN_NAME)
        except:
            return None

    @property
    def blueprint(self):
        endpoint_parts = (self.endpoint or '').split('.')
        blueprint_name, blueprint_endpoint = endpoint_parts if len(endpoint_parts) == 2 else (None, None)
        return self.app.blueprints.get(blueprint_name)

    @property
    def blueprint_endpoint(self):
        """
        去掉blueprint前缀之后剩下的
        """
        endpoint_parts = (self.endpoint or '').split('.')
        blueprint_name, blueprint_endpoint = endpoint_parts if len(endpoint_parts) == 2 else (None, None)
        return blueprint_endpoint

    def __repr__(self):
        return 'endpoint: %(endpoint)s, raw_data: %(raw_data)s' % dict(
            endpoint=str(self.endpoint),
            raw_data=str(self.raw_data),
        )