/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.util;

import org.snu.ids.ha.util.StringSet;
import org.snu.ids.ha.util.Util;

public class Hangul {
    public static final StringSet MO_POSITIVE_SET = new StringSet(new String[]{"\u314f", "\u3150", "\u3151", "\u3152", "\u3157", "\u315b", "\u3158"});
    public static final StringSet MO_NEGATIVE_SET = new StringSet(new String[]{"\u3153", "\u3154", "\u3155", "\u3156", "\u315c", "\u3160", "\u315d", "\u315e", "\u315f", "\u315a", "\u3159"});
    public static final StringSet MO_NEUTRIAL_SET = new StringSet(new String[]{"\u3161", "\u3163", "\u3162"});
    public static final StringSet MO_DOUBLE_SET = new StringSet(new String[]{"\u3158", "\u315d", "\u315e", "\u315f", "\u315a", "\u3159"});
    public char cho = '\u0000';
    public char jung = '\u0000';
    public char jong = '\u0000';

    public String toString() {
        return "(" + this.cho + "," + this.jung + "," + this.jong + ")";
    }

    private String get() {
        String ret = this.cho == '\u0000' ? "" : String.valueOf(this.cho);
        ret = String.valueOf(ret) + (this.jung == '\u0000' ? "" : String.valueOf(this.jung));
        switch (this.jong) {
            case '\u0000': {
                ret = String.valueOf(ret);
                break;
            }
            case '\u3133': {
                ret = String.valueOf(ret) + "\u3131\u3145";
                break;
            }
            case '\u3135': {
                ret = String.valueOf(ret) + "\u3134\u314b";
                break;
            }
            case '\u3136': {
                ret = String.valueOf(ret) + "\u3134\u314e";
                break;
            }
            case '\u313a': {
                ret = String.valueOf(ret) + "\u3139\u3131";
                break;
            }
            case '\u313b': {
                ret = String.valueOf(ret) + "\u3139\u3141";
                break;
            }
            case '\u313c': {
                ret = String.valueOf(ret) + "\u3139\u3142";
                break;
            }
            case '\u313d': {
                ret = String.valueOf(ret) + "\u3139\u3145";
                break;
            }
            case '\u313e': {
                ret = String.valueOf(ret) + "\u3139\u314c";
                break;
            }
            case '\u313f': {
                ret = String.valueOf(ret) + "\u3139\u314d";
                break;
            }
            case '\u3140': {
                ret = String.valueOf(ret) + "\u3139\u314e";
                break;
            }
            case '\u3144': {
                ret = String.valueOf(ret) + "\u3142\u3145";
                break;
            }
            default: {
                ret = String.valueOf(ret) + this.jong;
            }
        }
        return ret;
    }

    public boolean hasCho() {
        return this.cho != '\u0000';
    }

    public boolean hasJung() {
        return this.jung != '\u0000';
    }

    public boolean hasJong() {
        return this.jong != '\u0000';
    }

    protected static final char getCho(int idx) {
        char ret = '\u0000';
        switch (idx) {
            case 0: {
                ret = '\u3131';
                break;
            }
            case 1: {
                ret = '\u3132';
                break;
            }
            case 2: {
                ret = '\u3134';
                break;
            }
            case 3: {
                ret = '\u3137';
                break;
            }
            case 4: {
                ret = '\u3138';
                break;
            }
            case 5: {
                ret = '\u3139';
                break;
            }
            case 6: {
                ret = '\u3141';
                break;
            }
            case 7: {
                ret = '\u3142';
                break;
            }
            case 8: {
                ret = '\u3143';
                break;
            }
            case 9: {
                ret = '\u3145';
                break;
            }
            case 10: {
                ret = '\u3146';
                break;
            }
            case 11: {
                ret = '\u3147';
                break;
            }
            case 12: {
                ret = '\u3148';
                break;
            }
            case 13: {
                ret = '\u3149';
                break;
            }
            case 14: {
                ret = '\u314a';
                break;
            }
            case 15: {
                ret = '\u314b';
                break;
            }
            case 16: {
                ret = '\u314c';
                break;
            }
            case 17: {
                ret = '\u314d';
                break;
            }
            case 18: {
                ret = '\u314e';
            }
        }
        return ret;
    }

    protected static final int getChoIdx(char ch) {
        int ret = -1;
        switch (ch) {
            case '\u3131': {
                ret = 0;
                break;
            }
            case '\u3132': {
                ret = 1;
                break;
            }
            case '\u3134': {
                ret = 2;
                break;
            }
            case '\u3137': {
                ret = 3;
                break;
            }
            case '\u3138': {
                ret = 4;
                break;
            }
            case '\u3139': {
                ret = 5;
                break;
            }
            case '\u3141': {
                ret = 6;
                break;
            }
            case '\u3142': {
                ret = 7;
                break;
            }
            case '\u3143': {
                ret = 8;
                break;
            }
            case '\u3145': {
                ret = 9;
                break;
            }
            case '\u3146': {
                ret = 10;
                break;
            }
            case '\u3147': {
                ret = 11;
                break;
            }
            case '\u3148': {
                ret = 12;
                break;
            }
            case '\u3149': {
                ret = 13;
                break;
            }
            case '\u314a': {
                ret = 14;
                break;
            }
            case '\u314b': {
                ret = 15;
                break;
            }
            case '\u314c': {
                ret = 16;
                break;
            }
            case '\u314d': {
                ret = 17;
                break;
            }
            case '\u314e': {
                ret = 18;
            }
        }
        return ret;
    }

    protected static final char getJung(int idx) {
        char ret = '\u0000';
        switch (idx) {
            case 0: {
                ret = '\u314f';
                break;
            }
            case 1: {
                ret = '\u3150';
                break;
            }
            case 2: {
                ret = '\u3151';
                break;
            }
            case 3: {
                ret = '\u3152';
                break;
            }
            case 4: {
                ret = '\u3153';
                break;
            }
            case 5: {
                ret = '\u3154';
                break;
            }
            case 6: {
                ret = '\u3155';
                break;
            }
            case 7: {
                ret = '\u3156';
                break;
            }
            case 8: {
                ret = '\u3157';
                break;
            }
            case 9: {
                ret = '\u3158';
                break;
            }
            case 10: {
                ret = '\u3159';
                break;
            }
            case 11: {
                ret = '\u315a';
                break;
            }
            case 12: {
                ret = '\u315b';
                break;
            }
            case 13: {
                ret = '\u315c';
                break;
            }
            case 14: {
                ret = '\u315d';
                break;
            }
            case 15: {
                ret = '\u315e';
                break;
            }
            case 16: {
                ret = '\u315f';
                break;
            }
            case 17: {
                ret = '\u3160';
                break;
            }
            case 18: {
                ret = '\u3161';
                break;
            }
            case 19: {
                ret = '\u3162';
                break;
            }
            case 20: {
                ret = '\u3163';
            }
        }
        return ret;
    }

    protected static final int getJungIdx(char ch) {
        int ret = -1;
        switch (ch) {
            case '\u314f': {
                ret = 0;
                break;
            }
            case '\u3150': {
                ret = 1;
                break;
            }
            case '\u3151': {
                ret = 2;
                break;
            }
            case '\u3152': {
                ret = 3;
                break;
            }
            case '\u3153': {
                ret = 4;
                break;
            }
            case '\u3154': {
                ret = 5;
                break;
            }
            case '\u3155': {
                ret = 6;
                break;
            }
            case '\u3156': {
                ret = 7;
                break;
            }
            case '\u3157': {
                ret = 8;
                break;
            }
            case '\u3158': {
                ret = 9;
                break;
            }
            case '\u3159': {
                ret = 10;
                break;
            }
            case '\u315a': {
                ret = 11;
                break;
            }
            case '\u315b': {
                ret = 12;
                break;
            }
            case '\u315c': {
                ret = 13;
                break;
            }
            case '\u315d': {
                ret = 14;
                break;
            }
            case '\u315e': {
                ret = 15;
                break;
            }
            case '\u315f': {
                ret = 16;
                break;
            }
            case '\u3160': {
                ret = 17;
                break;
            }
            case '\u3161': {
                ret = 18;
                break;
            }
            case '\u3162': {
                ret = 19;
                break;
            }
            case '\u3163': {
                ret = 20;
            }
        }
        return ret;
    }

    protected static final char getJong(int idx) {
        char ret = '\u0000';
        switch (idx) {
            case 0: {
                ret = '\u0000';
                break;
            }
            case 1: {
                ret = '\u3131';
                break;
            }
            case 2: {
                ret = '\u3132';
                break;
            }
            case 3: {
                ret = '\u3133';
                break;
            }
            case 4: {
                ret = '\u3134';
                break;
            }
            case 5: {
                ret = '\u3135';
                break;
            }
            case 6: {
                ret = '\u3136';
                break;
            }
            case 7: {
                ret = '\u3137';
                break;
            }
            case 8: {
                ret = '\u3139';
                break;
            }
            case 9: {
                ret = '\u313a';
                break;
            }
            case 10: {
                ret = '\u313b';
                break;
            }
            case 11: {
                ret = '\u313c';
                break;
            }
            case 12: {
                ret = '\u313d';
                break;
            }
            case 13: {
                ret = '\u313e';
                break;
            }
            case 14: {
                ret = '\u313f';
                break;
            }
            case 15: {
                ret = '\u3140';
                break;
            }
            case 16: {
                ret = '\u3141';
                break;
            }
            case 17: {
                ret = '\u3142';
                break;
            }
            case 18: {
                ret = '\u3144';
                break;
            }
            case 19: {
                ret = '\u3145';
                break;
            }
            case 20: {
                ret = '\u3146';
                break;
            }
            case 21: {
                ret = '\u3147';
                break;
            }
            case 22: {
                ret = '\u3148';
                break;
            }
            case 23: {
                ret = '\u314a';
                break;
            }
            case 24: {
                ret = '\u314b';
                break;
            }
            case 25: {
                ret = '\u314c';
                break;
            }
            case 26: {
                ret = '\u314d';
                break;
            }
            case 27: {
                ret = '\u314e';
            }
        }
        return ret;
    }

    protected static final int getJongIdx(char ch) {
        int ret = -1;
        switch (ch) {
            case '\u0000': {
                ret = 0;
                break;
            }
            case ' ': {
                ret = 0;
                break;
            }
            case '\u3131': {
                ret = 1;
                break;
            }
            case '\u3132': {
                ret = 2;
                break;
            }
            case '\u3133': {
                ret = 3;
                break;
            }
            case '\u3134': {
                ret = 4;
                break;
            }
            case '\u3135': {
                ret = 5;
                break;
            }
            case '\u3136': {
                ret = 6;
                break;
            }
            case '\u3137': {
                ret = 7;
                break;
            }
            case '\u3139': {
                ret = 8;
                break;
            }
            case '\u313a': {
                ret = 9;
                break;
            }
            case '\u313b': {
                ret = 10;
                break;
            }
            case '\u313c': {
                ret = 11;
                break;
            }
            case '\u313d': {
                ret = 12;
                break;
            }
            case '\u313e': {
                ret = 13;
                break;
            }
            case '\u313f': {
                ret = 14;
                break;
            }
            case '\u3140': {
                ret = 15;
                break;
            }
            case '\u3141': {
                ret = 16;
                break;
            }
            case '\u3142': {
                ret = 17;
                break;
            }
            case '\u3144': {
                ret = 18;
                break;
            }
            case '\u3145': {
                ret = 19;
                break;
            }
            case '\u3146': {
                ret = 20;
                break;
            }
            case '\u3147': {
                ret = 21;
                break;
            }
            case '\u3148': {
                ret = 22;
                break;
            }
            case '\u314a': {
                ret = 23;
                break;
            }
            case '\u314b': {
                ret = 24;
                break;
            }
            case '\u314c': {
                ret = 25;
                break;
            }
            case '\u314d': {
                ret = 26;
                break;
            }
            case '\u314e': {
                ret = 27;
            }
        }
        return ret;
    }

    public static Hangul split(char ch) {
        Hangul hangul = new Hangul();
        int x = ch & 0xFFFF;
        int y = 0;
        int z = 0;
        if (x >= 44032 && x <= 55203) {
            y = x - 44032;
            z = y % 588;
            hangul.cho = Hangul.getCho(y / 588);
            hangul.jung = Hangul.getJung(z / 28);
            hangul.jong = Hangul.getJong(z % 28);
        } else if (x >= 12593 && x <= 12643) {
            if (Hangul.getChoIdx(ch) > -1) {
                hangul.cho = ch;
            } else if (Hangul.getJungIdx(ch) > -1) {
                hangul.jung = ch;
            } else if (Hangul.getJongIdx(ch) > -1) {
                hangul.jong = ch;
            }
        } else {
            hangul.cho = ch;
        }
        return hangul;
    }

    public static String split(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int stop = string.length();
        while (i < stop) {
            sb.append(Hangul.split(string.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    public static char combine(char cho, char jung, char jong) {
        return (char)(Hangul.getChoIdx(cho) * 21 * 28 + Hangul.getJungIdx(jung) * 28 + Hangul.getJongIdx(jong) + 44032);
    }

    public static String append(String head, String tail) {
        String ret = null;
        Hangul headTail = Hangul.split(head.charAt(head.length() - 1));
        Hangul tailHead = Hangul.split(tail.charAt(0));
        if (tailHead.hasJung() || headTail.hasJong()) {
            ret = String.valueOf(head) + tail;
        } else {
            String headHead = head.substring(0, head.length() - 1);
            String tailTail = tail.substring(1);
            ret = String.valueOf(headHead) + Hangul.combine(headTail.cho, headTail.jung, tailHead.cho) + tailTail;
        }
        return ret;
    }

    public static boolean hasJong(char ch) {
        return Hangul.split(ch).hasJong();
    }

    public static boolean hasJong(String string) {
        if (!Util.valid(string)) {
            return false;
        }
        return Hangul.hasJong(string.charAt(string.length() - 1));
    }

    public static String split2(String string) {
        if (string == null) {
            return null;
        }
        String ret = "";
        int i = 0;
        int stop = string.length();
        while (i < stop) {
            ret = String.valueOf(ret) + Hangul.split(string.charAt(i)).get() + ":";
            ++i;
        }
        return ret;
    }

    public static boolean endsWith(String string, String pattern) {
        int plen;
        if (!Util.valid(string) || !Util.valid(pattern)) {
            return false;
        }
        int slen = string.length();
        if (slen < (plen = pattern.length())) {
            return false;
        }
        char sch = '\u0000';
        char pch = '\u0000';
        int i = 0;
        while (i < plen) {
            sch = string.charAt(slen - i - 1);
            pch = pattern.charAt(plen - i - 1);
            if (pch != sch) {
                if (i == plen - 1) {
                    return Hangul.endsWith2(sch, pch);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean endsWith(char sch, char pch) {
        if (sch == pch) {
            return true;
        }
        return Hangul.endsWith2(sch, pch);
    }

    private static boolean endsWith2(char sch, char pch) {
        String stemp = Hangul.split(sch).get();
        String ptemp = Hangul.split(pch).get();
        return stemp.endsWith(ptemp);
    }

    public static String removeEnd(String string, String pattern) {
        String ptemp;
        int plen;
        if (!Util.valid(string) || !Util.valid(pattern)) {
            return string;
        }
        int slen = string.length();
        if (slen < (plen = pattern.length())) {
            return string;
        }
        if (string.endsWith(pattern)) {
            return string.substring(0, slen - plen);
        }
        if (!pattern.substring(1).equals(string.substring(slen - plen + 1))) {
            return string;
        }
        String stemp = Hangul.split(string.charAt(slen - plen)).get();
        if (!stemp.endsWith(ptemp = Hangul.split(pattern.charAt(0)).get())) {
            return string;
        }
        String temp = stemp.substring(0, stemp.length() - ptemp.length());
        char[] ch = new char[3];
        int i = 0;
        int stop = temp.length();
        while (i < stop) {
            ch[i] = temp.charAt(i);
            ++i;
        }
        String ret = slen > plen ? string.substring(0, slen - plen) : "";
        char rch = Hangul.combine(ch[0], ch[1], ch[2]);
        if (rch == '\u0000') {
            return ret;
        }
        ret = String.valueOf(ret) + Hangul.combine(ch[0], ch[1], ch[2]);
        return ret;
    }

    public static String extractExtraEomi(String string, int len) {
        int strlen = string.length();
        if (!Util.valid(string) || strlen < len) {
            return null;
        }
        Hangul hg = Hangul.split(string.charAt(strlen - len));
        if (!hg.hasJong()) {
            return null;
        }
        String temp = hg.get();
        return String.valueOf(temp.charAt(temp.length() - 1)) + string.substring(strlen - len + 1);
    }
}

