# -*- coding: utf-8 -*-

"""
KParcel

KParcel parses the website or web API response of
Korean parcel delivery service company for tracking the parcel.

https://bitbucket.org/quicket/kparcel_open
"""

from kparcel.base import Parser
from parser import (
        DoortodoorParser,
        CVSNetParser,
        LogenParser,
        EPostParser,
        HanjinParser,
        KGBParser,
        HyundaiParser,
        KGYellowCapParser,
        DongbuParser,
        EMSParser,
        KyoungdongParser,
        IlyangParser,
        DaesinParser,
        HapdongParser,
        ChunilParser,
        GTXParser
        )

__author__ = "Han Manjong (mjhan@quicket.co.kr)"
__version__ = "1.0.1"
__copyright__ = "Copyright (c) 2014 Quicket, Inc."
__license__ = "Apache"

__all__ = ['KParcel']

class KParcel(object) :

    company_list = {
            'cj': DoortodoorParser,
            'cvs': CVSNetParser,
            'logen': LogenParser,
            'epost': EPostParser,
            'hanjin': HanjinParser,
            'kgb': KGBParser,
            'hyundai': HyundaiParser,
            'kyoungdong': KyoungdongParser,
            'ilyang': IlyangParser,
            'daesin': DaesinParser,
            'ems': EMSParser,
            'dongbu': DongbuParser,
            'kgyellow': KGYellowCapParser,
            'hapdong': HapdongParser,
            'chunil': ChunilParser,
            'gtx': GTXParser
        }
    def __new__(self, invoice_number=None, company=None):
        if invoice_number != None and company != None:
            new_parser = self.company_list.get(company, Parser)
            return new_parser(invoice_number)
        return self

