# -*- coding: utf-8 -*-

import re
from bs4 import BeautifulSoup
from kparcel.base import Parser, DEBUG


# TODO: 우체국으로부터 발급받은 API Key를 입력해야 합니다.
KEY_API_AUTH_EPOST = ''

URL_API_CVS_NET     = 'http://www.cvsnet.co.kr/_ver2/board/ctod_status_new.jsp'
URL_API_DOORTODOOR  = 'http://www.doortodoor.co.kr/tracking/jsp/cmn/Tracking_new.jsp?QueryType=3&pOrderNo=&pTelNo=&pFromDate=&pToDate=&pCustId=&pageno=1&rcv_cnt=10&pTdNo=%s'
URL_API_LOGEN       = 'http://www.ilogen.com/homeshopping/stracker_trace_xml.asp?invoice=%s'
URL_API_EPOST       = 'http://openapi.epost.go.kr/trace/retrieveLongitudinalService/retrieveLongitudinalService/getLongitudinalDomesticList?ServiceKey=%s&rgist=%s'
URL_API_HANJIN      = 'http://www.hanjin.co.kr/Delivery_html/inquiry/result_waybill.jsp?wbl_num=%s'
URL_API_KGB         = 'http://www.kgbls.co.kr/auction/?number=%s'
URL_API_HYUNDAI     = 'http://www.hlc.co.kr/hydex/jsp/tracking/trackingViewCus.jsp?InvNo=%s'
URL_API_KGYELLOWCAP = 'https://www.kgyellowcap.co.kr/delivery/waybill.html?mode=bill'
URL_API_DONGBU      = 'http://www.dongbups.com/newHtml/delivery/dvsearch_View.jsp?item_no=%s'
URL_API_EMS         = 'http://trace.epost.go.kr/xtts/servlet/kpl.tts.common.svl.SttSVL?target_command=kpl.tts.tt.epost.cmd.RetrieveOrderEpostPoEmsKorCMD&JspURI=/xtts/tt/epost/ems/EmsSearchResult.jsp&POST_CODE=%s'
URL_API_KYOUNGDONG  = 'http://www.kdexp.com/auction/mya_2_1_22.asp?barcode=%s'
URL_API_ILYANG      = 'http://www.ilyanglogis.com/functionality/auction_pop.asp?hawb_no=%s'
URL_API_DAESIN      = 'http://211.51.241.142/daesin/jsp/trace/d_trace_auction.jsp?billno1=%s'
URL_API_CHUNIL      = 'http://www.cyber1001.co.kr/HTrace/auction.jsp?transNo=%s'
URL_API_HAPDONG     = 'http://www.hdexp.co.kr/parcel/order_result_t.asp?p_item=%s'
URL_API_GTX         = 'http://www.gtxlogis.co.kr/tracking/tracking_xml.asp?invoice=%s'

URL_WEB_EPOST = 'http://service.epost.go.kr/mobile.RetrieveRegiPrclDelivTibco.postal?sid1=%s'
URL_WEB_LOGEN = 'http://m.ilogen.com/mobile/trace_r.asp?gubun=slipno&value1=%s'
URL_WEB_GTX   = 'http://www.gtxlogis.co.kr/tracking/mobile_default.asp?awblno=%s'

HTTP_HEADER_REFERER_CVS_NET      = 'http://www.cvsnet.co.kr/_ver2/03_track/track_01.jsp?pageNum=3&subNum=1&ssNum=0'
HTTP_HEADER_CONTENT_TYPE_CVS_NET = 'application/x-www-form-urlencoded'
HTTP_CONTENT_CVS_NET             = 'select_flag1=2&invoice_no=%s'


class KGBParser(Parser):
    def __init__(self, invoice_number):
        super(KGBParser, self).__init__(invoice_number)
        self.company.name  = 'KGB택배'
        self.company.code  = 'kgb'
        self.company.digit = 10
        self.company.phone = '1577-4577'
        self.company.url   = 'http://www.kgbls.co.kr'
        self.request.url = URL_API_KGB % invoice_number

    def browse(self, request):
        return Parser.browse(self, request).decode('ms949', 'ignore')

    def parse(self, response):
        soup = BeautifulSoup(response, 'lxml')
        tables = soup.find_all('table')

        invoice_info = tables[0].find_all('tr')

        invoice_info_col = invoice_info[0].find_all('th')
        invoice_info_row = invoice_info[1].find_all('td')

        customer_info = tables[1].find_all('tr')

        customer_info_col = customer_info[0].find_all('th')
        customer_info_row = customer_info[1].find_all('td')

        sender_name = ''
        receiver_name = getattr(customer_info_row[0], 'get_text', '')(strip=True)
        address = getattr(customer_info_row[1], 'get_text', '')(strip=True)

        self.set_basic_info(sender_name, receiver_name, address)
        if (DEBUG):
            print self.basic_info

        tracking_info = tables[2].find_all('tr')

        tracking_info_col = tracking_info[0].find_all('th')
        for i in range(1, len(tracking_info), 1):
            tracking_info_row = tracking_info[i].find_all('td')

            time = getattr(tracking_info_row[0], 'get_text', '')(strip=True)
            location = getattr(tracking_info_row[1], 'get_text', '')(strip=True)
            status = getattr(tracking_info_row[3], 'get_text', '')(strip=True)
            self.add_tracking_info(time, location, status)

            phone = getattr(tracking_info_row[2], 'get_text', '')(strip=True)
            self.add_tracking_info_details(status, location, phone, self.company.phone)

        if (DEBUG):
            for row in self.tracking_infos :
                print row

            for row in self.tracking_info_details :
                print row

        return

class KyoungdongParser(KGBParser):
    def __init__(self, invoice_number):
        super(KyoungdongParser, self).__init__(invoice_number)
        self.company.name  = '경동택배'
        self.company.code  = 'kyoungdong'
        self.company.digit = 12
        self.company.phone = '031-460-2400'
        self.company.url   = 'http://www.kdexp.com'
        self.request.url = URL_API_KYOUNGDONG % invoice_number

class IlyangParser(KGBParser):
    def __init__(self, invoice_number):
        super(IlyangParser, self).__init__(invoice_number)
        self.company.name  = '일양택배'
        self.company.code  = 'ilyang'
        self.company.digit = 9
        self.company.phone = '1588-0002'
        self.company.url   = 'http://www.ilyanglogis.com'
        self.request.url = URL_API_ILYANG % invoice_number

class DaesinParser(KGBParser):
    def __init__(self, invoice_number):
        super(DaesinParser, self).__init__(invoice_number)
        self.company.name  = '대신택배'
        self.company.code  = 'daesin'
        self.company.digit = 13
        self.company.phone = '043-255-3211'
        self.company.url   = 'http://apps.ds3211.co.kr'
        self.request.url = URL_API_DAESIN % invoice_number

class ChunilParser(KGBParser):
    def __init__(self, invoice_number):
        super(ChunilParser, self).__init__(invoice_number)
        self.company.name  = '천일택배'
        self.company.code  = 'chunil'
        self.company.digit = 11
        self.company.phone = '051-647-1001'
        self.company.url   = 'http://www.cyber1001.co.kr'
        self.request.url = URL_API_CHUNIL % invoice_number

class HapdongParser(Parser):
    def __init__(self, invoice_number):
        super(HapdongParser, self).__init__(invoice_number)
        self.company.name  = '합동택배'
        self.company.code  = 'hapdong'
        self.company.digit = 12
        self.company.phone = '080-873-2178'
        self.company.url   = 'http://www.hdexp.co.kr'
        self.request.url = URL_API_HAPDONG % invoice_number

    def parse(self, response):
        soup = BeautifulSoup(response, 'lxml')
        tables = soup.find_all('table', { 'class': 'order_tb_result' })

        tds = tables[0].find_all('td')
        sender = getattr(tds[9], 'string', '')
        receiver = getattr(tds[11], 'string', '')
        address = getattr(tds[19], 'string', '')

        tr = tables[1].find_all('tr')[1]
        memo = getattr(tr.find_all('td')[3], 'string', '') + ' ' + getattr(tr.find_all('td')[4], 'string', '')

        self.set_basic_info(sender, receiver, address, memo=memo)

        trs = tables[2].find_all('tr')
        for i, tr in enumerate(trs):
            if i != 0:
                tds = tr.find_all('td')

                time = getattr(tds[0], 'string', '')
                location = getattr(tds[1], 'string', '')
                phone = getattr(tds[2], 'string', '')
                status = getattr(tds[3], 'string', '')
                self.add_tracking_info(time, location, status)
                self.add_tracking_info_details(status, location, phone, self.company.phone)

        return

class EMSParser(Parser):
    def __init__(self, invoice_number):
        super(EMSParser, self).__init__(invoice_number)
        self.company.name  = 'EMS'
        self.company.code  = 'ems'
        self.company.digit = 13
        self.company.phone = '1588-1300'
        self.company.url   = 'http://service.epost.go.kr'
        self.request.url = URL_API_EMS % invoice_number

    def parse(self, response):
        soup = BeautifulSoup(response, 'lxml')
        div = soup.find('div', { 'class': 'sub_emspop_table' })
        table = div.find('table')

        cols = table.find('thead').find('tr').find_all('th')
        rows = table.find('tbody').find_all('tr')

        self.set_basic_info('', '', '')

        for row in rows:
            tds = row.find_all('td')

            time = getattr(tds[0], 'string', '')
            location = getattr(tds[2], 'string', '')
            status = getattr(tds[1], 'string', '')
            self.add_tracking_info(time, location, status)

        if (DEBUG):
            for row in self.tracking_infos:
                print row

        return

class DongbuParser(Parser):
    def __init__(self, invoice_number):
        super(DongbuParser, self).__init__(invoice_number)
        self.company.name  = '동부택배'
        self.company.code  = 'dongbu'
        self.company.digit = 12
        self.company.phone = '1588-8848'
        self.company.url   = 'http://www.dongbups.com'
        self.request.url = URL_API_DONGBU % invoice_number

    def parse(self, response):
        soup = BeautifulSoup(response, 'lxml')
        tables = soup.find_all('table', { 'class': 'dv_list' })

        basicTable = tables[0]
        trs = basicTable.find_all('tr')

        sender = getattr(trs[1].find_all('td')[0], 'string', '')
        receiver = getattr(trs[1].find_all('td')[1], 'string', '')

        self.set_basic_info(sender, receiver, '')
        if (DEBUG):
            print self.basic_info

        trackTable = tables[1]
        trs = trackTable.find_all('tr')

        for tr in trs:
            tds = tr.find_all('td')
            if len(tds) != 0:
                time = getattr(tds[0], 'string', '') + ' ' + getattr(tds[1], 'string', '')
                location = getattr(tds[2], 'string', '').split('/')[0]
                status = getattr(tds[3], 'string', '')
                self.add_tracking_info(time, location, status)

                phone = getattr(tds[2], 'string', '').split('/')[1]
                self.add_tracking_info_details(status, location, ''.join(phone.split()), self.company.phone)

        if (DEBUG):
            for row in self.tracking_infos:
                print row

            for row in self.tracking_info_details:
                print row

        return

class KGYellowCapParser(Parser):
    def __init__(self, invoice_number):
        super(KGYellowCapParser, self).__init__(invoice_number)
        self.company.name  = 'KG옐로우캡'
        self.company.code  = 'kgyellow'
        self.company.digit = 11
        self.company.phone = '1588-0123'
        self.company.url   = 'https://www.kgyellowcap.co.kr'
        self.request.url = URL_API_KGYELLOWCAP
        self.request.content = 'delivery=' + invoice_number

    def parse(self, response):
        soup = BeautifulSoup(response, 'lxml')

        basicTable = soup.find('table', { 'class': 'view' })
        ths = basicTable.find_all('th')
        tds = basicTable.find_all('td')

        sender_name = getattr(tds[1], 'string', '')
        memo = getattr(tds[2], 'string', '')
        receiver_name = getattr(tds[3], 'string', '')
        address = getattr(tds[5], 'string', '')

        self.set_basic_info(sender_name, receiver_name, address, memo=memo)
        if (DEBUG):
            print self.basic_info

        trackTable = soup.find('table', { 'class': 'list'})
        cols = trackTable.find('thead').find('tr').find_all('th')
        rows = trackTable.find('tbody').find_all('tr')

        for row in rows:
            tds = row.find_all('td')

            time = getattr(tds[0], 'string', '')
            status = getattr(tds[1], 'string', '')
            location = getattr(tds[2], 'string', '')
            self.add_tracking_info(time, location, status)

            phone = getattr(tds[3], 'string', '')
            self.add_tracking_info_details(status, location, phone, self.company.phone)

        if (DEBUG):
            for tracking_info in self.tracking_infos:
                print 'Tracking Info: ', tracking_info

        return

class HyundaiParser(Parser):
    def __init__(self, invoice_number):
        super(HyundaiParser, self).__init__(invoice_number)
        self.company.name  = '현대택배'
        self.company.code  = 'hyundai'
        self.company.digit = 12
        self.company.phone = '1588-2121'
        self.company.url   = 'http://m.hlc.co.kr'
        self.request.url = URL_API_HYUNDAI % invoice_number

    def browse(self, request):
        return Parser.browse(self, request).decode('ms949', 'ignore')

    def parse(self, response):
        soup = BeautifulSoup(response, 'lxml')
        td = soup.find_all('td', { 'style': 'padding:0 0 0 10' })

        sender_name = td[0].get_text(strip=True)
        receiver_name = td[2].get_text(strip=True)
        address = td[3].get_text(strip=True)

        self.set_basic_info(sender_name if sender_name != 'null' else '',
                            receiver_name if receiver_name != 'null' else '',
                            address if address != 'null' else '')
        if (DEBUG):
            print self.basic_info

        dates = soup.find_all('td', {'width': '102', 'height': '28', 'align': 'center'})
        times = soup.find_all('td', {'width': '67', 'align': 'center'})
        places = soup.find_all('td', {'width': '108', 'align': 'center'})
        messages = soup.find_all('td', {'width': '277', 'style': 'padding:0 0 0 5'})

        for index, date in enumerate(dates):
            time = getattr(date, 'get_text', '')(strip=True) + ' ' + getattr(times[index], 'get_text', '')(strip=True)
            location = getattr(places[index], 'get_text', '')(strip=True)
            status = getattr(messages[index], 'get_text', '')(strip=True)
            self.add_tracking_info(time, location, status)

        if (DEBUG):
            for row in self.tracking_infos:
                print 'Tracking Info: ', row

class HanjinParser(Parser):
    def __init__(self, invoice_number):
        super(HanjinParser, self).__init__(invoice_number)
        self.company.name  = '한진택배'
        self.company.code  = 'hanjin'
        self.company.digit = 12
        self.company.phone = '1588-0011'
        self.company.url   = 'http://m.hanjin.co.kr'
        self.request.url = URL_API_HANJIN % invoice_number

    def parse(self, response):
        soup = BeautifulSoup(response, 'lxml')
        tables = soup.find_all('tbody')

        if (len(tables) > 0):
            basic_info = tables[0].find_all('td', {'class': 'bb'})
            tracking_info = tables[1].find_all('tr')

            stuff_name = getattr(basic_info[1], 'get_text', '')(strip=True)
            sender_name = getattr(basic_info[3], 'get_text', '')(strip=True)
            receiver_name = getattr(basic_info[4], 'get_text', '')(strip=True)
            receiver_address = getattr(basic_info[5], 'get_text', '')(strip=True)

            self.set_basic_info(sender_name, receiver_name, receiver_address, memo=stuff_name)
            if (DEBUG):
                print self.basic_info

            for tr in tracking_info:
                tds = tr.find_all('td')

                date = getattr(tds[0], 'get_text', '')(strip=True)
                time = getattr(tds[1], 'get_text', '')(strip=True)
                location = getattr(tds[2], 'get_text', '')(strip=True)
                status = getattr(tds[3], 'get_text', '')(strip=True)
                self.add_tracking_info(date + ' ' + time, location, status)

                phone = getattr(tds[4], 'get_text', '')(strip=True)
                self.add_tracking_info_details(status, location, phone, self.company.phone)

            if (DEBUG):
                print 'Tracking Info List: '
                for row in self.tracking_infos:
                    print row

                print 'Tracking Info Detail List: '
                for row in self.tracking_info_details:
                    print row

        return

class EPostParser(Parser):
    def __init__(self, invoice_number):
        super(EPostParser, self).__init__(invoice_number)
        self.company.name  = '우체국택배'
        self.company.code  = 'epost'
        self.company.digit = 13
        self.company.phone = '1588-1300'
        self.company.url   = 'http://m.epost.go.kr'
        self.request.url = URL_API_EPOST % (KEY_API_AUTH_EPOST, invoice_number)
        self.webview_request.url = URL_WEB_EPOST % (invoice_number)

    def parse(self, response):
        soup = BeautifulSoup(response, 'lxml')
        longitudinal_domestic_list_response = soup.find('longitudinaldomesticlistresponse')

        cmm_msg_header = longitudinal_domestic_list_response.find('cmmmsgheader')
        request_msg_id = cmm_msg_header.find('requestmsgid').string
        response_msg_id = cmm_msg_header.find('responsemsgid').string
        response_time = cmm_msg_header.find('responsetime').string
        success_y_n = cmm_msg_header.find('successyn').string
        return_code = cmm_msg_header.find('returncode').string
        err_msg = cmm_msg_header.find('errmsg').string

        addrse_nm = longitudinal_domestic_list_response.find('addrsenm').string #수취인
        applcnt_nm = longitudinal_domestic_list_response.find('applcntnm').string   #발송인
        dlvy_de = longitudinal_domestic_list_response.find('dlvyde').string #배달일자
        dlvy_sttus = longitudinal_domestic_list_response.find('dlvysttus').string   #배달상태

        longitudinal_domestic_list = longitudinal_domestic_list_response.find_all('longitudinaldomesticlist')    #종적목록
        for longitudinal_domestic in longitudinal_domestic_list:
            dlvy_date = longitudinal_domestic.find('dlvydate').string #날짜
            dlvy_time = longitudinal_domestic.find('dlvytime').string #시간
            now_lc = longitudinal_domestic.find('nowlc').string   #현재위치
            process_sttus = longitudinal_domestic.find('processsttus').string #처리현황
            detail_dc = longitudinal_domestic.find('detaildc').string #상세설명

            time = dlvy_date + ' ' + dlvy_time
            self.add_tracking_info(time, now_lc, process_sttus)

        pstmtr_knd = longitudinal_domestic_list_response.find('pstmtrknd').string   #우편물종류
        rgist = longitudinal_domestic_list_response.find('rgist').string   #등기번호
        trtmnt_se = longitudinal_domestic_list_response.find('trtmntse').string #취급구분

        self.set_basic_info(applcnt_nm, addrse_nm, '')
        if (DEBUG):
            print self.basic_info

            print 'Tracking Info List: '
            for row in self.tracking_infos:
                print row

        return

class LogenParser(Parser):
    def __init__(self, invoice_number):
        super(LogenParser, self).__init__(invoice_number)
        self.company.name  = '로젠택배'
        self.company.code  = 'logen'
        self.company.digit = 11
        self.company.phone = '1588-9988'
        self.company.url   = 'http://m.ilogen.com'
        self.request.url = URL_API_LOGEN % invoice_number
        self.webview_request.url = URL_WEB_LOGEN % (invoice_number)

    def browse(self, request):
        return Parser.browse(self, request).decode('ms949', 'ignore')

    def parse(self, response):
        soup = BeautifulSoup(response, 'html5lib')
        tracking_info = soup.find('tracking_info')

        sender_name = getattr(tracking_info.find('sender_name'), 'string', '')
        receiver_name = getattr(tracking_info.find('reciver_name'), 'string', '')
        receiver_addr = getattr(tracking_info.find('reciver_addr'), 'string', '')
        item_name = getattr(tracking_info.find('item_name'), 'string', '')

        if sender_name != None:
            sender_name = re.sub('[\[CDATA\]]', '', sender_name)

        if receiver_name != None:
            receiver_name = re.sub('[\[CDATA\]]', '', receiver_name)

        if receiver_addr != None:
            receiver_addr = re.sub('[\[CDATA\]]', '', receiver_addr)

        self.set_basic_info(sender_name, receiver_name, receiver_addr, memo=item_name)
        if (DEBUG) :
            print self.basic_info

        list_tracking_details = tracking_info.find_all('tracking_details')

        for tracking_details in list_tracking_details:
            trans_time = getattr(tracking_details.find('trans_time'), 'string', '')
            trans_kind = getattr(tracking_details.find('trans_kind'), 'string', '')
            trans_where = getattr(tracking_details.find('trans_where'), 'string', '')
            trans_telno = getattr(tracking_details.find('trans_telno'), 'string', '')

            self.add_tracking_info(trans_time, trans_where, trans_kind)
            self.add_tracking_info_details(trans_kind, trans_where, trans_telno, self.company.phone)

        if (DEBUG):
            for row in self.tracking_infos:
                print row

            for row in self.tracking_info_details:
                print row

        return

class GTXParser(LogenParser):
    def __init__(self, invoice_number):
        super(GTXParser, self).__init__(invoice_number)
        self.company.name  = 'GTX로지스'
        self.company.code  = 'gtx'
        self.company.digit = 12
        self.company.phone = '1588-1756'
        self.company.url   = 'http://www.gtxlogis.co.kr'
        self.request.url = URL_API_GTX % invoice_number
        self.webview_request.url = URL_WEB_GTX % invoice_number

class DoortodoorParser(Parser):
    def __init__(self, invoice_number):
        super(DoortodoorParser, self).__init__(invoice_number)
        self.company.name  = 'CJ대한통운'
        self.company.code  = 'cj'
        self.company.digit = 10
        self.company.phone = '1588-1255'
        self.company.url   = 'http://m.doortodoor.co.kr'
        self.request.url = URL_API_DOORTODOOR % invoice_number

    def set_basic_info(self, sender, receiver, address, memo=None):
        Parser.set_basic_info(self, sender, receiver, address, memo=memo)
        self.basic_info.memo = '' if self.basic_info.memo == ',' else memo

    def parse(self, response):
        soup = BeautifulSoup(response, 'lxml')

        tables = soup.find_all('tbody')
        cols = soup.find('thead').find('tr').find_all('th')

        trs = tables[0].find_all('tr')
        customer_infos = []
        for tr in trs:
            ths = tr.find_all('th')
            tds = tr.find_all('td')

            for index, th in enumerate(ths):
                td = tds[index].get_text(strip=True)

                if th != '':
                    customer_infos.append(td)

        self.set_basic_info(customer_infos[1], customer_infos[4], customer_infos[6], memo=customer_infos[7])
        if (DEBUG):
            print self.basic_info

        trs = tables[1].find_all('tr')
        for tr in trs:
            tds = tr.find_all('td')

            location = getattr(tds[0], 'get_text', '')(strip=True)
            phone1 = getattr(tds[1], 'get_text', '')(strip=True)
            status = getattr(tds[2], 'get_text', '')(strip=True)
            time = getattr(tds[3], 'get_text', '')(strip=True)
            self.add_tracking_info(time, location, status)

            phone2 = getattr(tds[6], 'get_text', '')(strip=True)
            self.add_tracking_info_details(status, location, phone1, phone2)

        if (DEBUG):
            for row in self.tracking_infos:
                print row

            for row in self.tracking_info_details:
                print row

        return

class CVSNetParser(DoortodoorParser):
    def __init__(self, invoice_number):
        super(CVSNetParser, self).__init__(invoice_number)
        self.company.name  = 'CVSNet편의점택배'
        self.company.code  = 'cvs'
        self.company.digit = 10
        self.company.phone = '1577-1287'
        self.company.url   = 'http://www.cvsnet.co.kr'
