# -*- coding: utf-8 -*-

from contextlib import closing
import urllib2


DEBUG                   = False
HTTP_HEADER_USER_AGENT  = 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:2.0) Gecko/20100101 Firefox/4.0'


class Company(object):
    """
    Company object
    """

    # 택배사 이름
    name = ''

    # 택배사 코드
    code = ''

    # 운송장번호 자릿수
    digit = 9

    # 택배사 고객센터 전화번호
    phone = ''

    # 택배사 API URL
    url = ''

    def __repr__(self):
        return 'name: %s, code: %s, digit: %s, phone: %s, url: %s' % (self.name, self.code,
                                                                      self.digit, self.phone, self.url)

class Customer(object):
    """
    Customer object
    """

    # 보내시는 분
    sender = ''

    # 받으시는 분
    receiver = ''

    # 운송장번호
    invoice_number = 0

    # 목적지 주소
    address = ''

    # 택배사
    company = Company()

    # 배송메모(상품명)
    memo = ''

    def __repr__(self):
        return 'sender: %s, receiver: %s, invoice number: %s, address: %s, company: %s, memo: %s' % (self.sender,
                                                                                           self.receiver,
                                                                                           self.invoice_number,
                                                                                           self.address, self.company,
                                                                                           self.memo)

class Parcel(object):
    """
    Parcel object
    """

    # 시간
    time = ''

    # 위치
    location = ''

    # 상태
    status = ''

    def is_empty(self):
        if self.time == '' and self.location == '' and self.status == '':
            return True
        return False

    def __repr__(self):
        return 'time: %s, location: %s, status: %s' % (self.time, self.location, self.status)

class ParcelDetail(object):
    """
    ParcelDetail object
    """

    # 상태
    status = ''

    # 위치
    location = ''

    # 전화번호1
    phone1 = ''

    # 전화번호2
    phone2 = ''

    def is_empty(self):
        if self.location == '' and self.status == '' and \
            self.phone1 == '' and self.phone2 == '':
            return True
        return False

    def __repr__(self):
        return 'status: %s, location: %s, phone1: %s, phone2: %s' % (self.status, self.location,
                                                                     self.phone1, self.phone2)

class ParserRequest(object):
    """
    ParserRequest object
    """

    # URL
    url = None

    # HTTP Header
    header = None

    # HTTP Content
    content = None

    def __repr__(self):
        return 'url: %s, header: %s, content: %s' % (self.url, self.header,
                                                    self.content)

class Parser(object):
    def __init__(self, invoice_number):

        self.invoice_number = invoice_number
        self.company = Company()

        # 기본 API
        self.basic_info = Customer()
        self.tracking_infos = []
        self.tracking_info_details = []

        # 웹페이지 접속 정보
        self.request = ParserRequest()

        # 모바일 웹뷰 접속 정보
        self.webview_request = ParserRequest()

    def browse(self, request):
        with closing(urllib2.urlopen(request)) as response:
            return response.read()

    def parse(self, response):
        return

    def set_basic_info(self, sender, receiver, address, memo=None):
        self.basic_info.sender = sender if sender != None else ''
        self.basic_info.receiver = receiver if receiver != None else ''
        self.basic_info.address = address if address != None else ''
        self.basic_info.memo = memo if memo != None else ''
        self.basic_info.invoice_number = self.invoice_number
        self.company = self.company

    def add_tracking_info(self, time, location, status):
        parcel = Parcel()
        parcel.time = time if time != None else ''
        parcel.location = location if location != None else ''
        parcel.status = status if status != None else ''

        if not parcel.is_empty():
            self.tracking_infos.append(parcel)

    def add_tracking_info_details(self, status, location, phone1, phone2):
        parcel_detail = ParcelDetail()
        parcel_detail.status = status if status != None else ''
        parcel_detail.location = location if location != None else ''
        parcel_detail.phone1 = phone1 if phone1 != None else ''
        parcel_detail.phone2 = phone2 if phone2 != None else ''

        if not parcel_detail.is_empty():
            self.tracking_info_details.append(parcel_detail)

    def get_request(self):
        return urllib2.Request(self.request.url, self.request.content,
                               { 'User-Agent': HTTP_HEADER_USER_AGENT })