#!/usr/bin/env python
# -*- coding: utf-8 -*-

from setuptools import setup
import glob
import os
import platform
import re
import sys

if platform.system() == 'FreeBSD':
    man_dir = 'man'
else:
    man_dir = 'share/man'

def publish():

    """Publish to PyPi"""
    os.system("python setup.py sdist upload")

if sys.argv[-1] == "publish":
    publish()
    sys.exit()


setup(
    name="krpython",
    version = "0.2.1",
    author = "Kenneth Reitz",
    author_email = "me@kennethreit.zcom",
    description = "Epic Interactive Python Interpreter w/ Gist Integration",
    license = "MIT",
    url = "http://github.com/kennethreitz/krpython",
    long_description = """krpython is a fancy interface to the Python
    interpreter for Unix-like operating systems.""",
    install_requires = [
        'pygments',
        'pyparsing',
        'xerox'
    ],
    packages = ["krpython"],
    data_files = [
        # (os.path.join(man_dir, 'man1'), ['doc/krpython.1']),
        # (os.path.join(man_dir, 'man5'), ['doc/krpythonrc.5'])
    ],
    entry_points = {
        'console_scripts': [
            'krpython = krpython.cli:main',
        ],
    }
)

# vim: encoding=utf-8 sw=4 ts=4 sts=4 ai et sta
