#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (c) 2010, David Sveningsson <ext@sidvind.com>
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the author nor the
#       names of its contributors may be used to endorse or promote products
#       derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

import pprint

f = open('/usr/share/X11/rgb.txt', 'r')
lines = f.readlines()
tokens = [x.split(None, 3) for x in lines]
convert = lambda x: hex(int(x))[2:]
items = [(name[:-1].lower(), (convert(r),convert(g),convert(b))) for (r,g,b,name) in tokens]
d = dict(items)

# Overwrite some colors which differs from x11 rgb.txt
d['gray']   = ('7f', '7f', '7f')
d['green']  = ('00', '7f', '00')
d['maroon'] = ('7f', '00', '00')
d['purple'] = ('7f', '00', '7f')

print '#!/usr/bin/python'
print '# -*- coding: utf-8 -*-'
print
print '# autogenerated from X11/rgb.txt'
print 'names = \\'
pp = pprint.PrettyPrinter(indent=4)
pp.pprint(d)
