import urllib2
import urllib
import re
from exceptions import *

__version__ = "1.0"
__author__ = "Ferdinand E. Silva"

class Jenereytor(object):
    
    def __init__(self):
        self.googleUrl = 'http://chart.apis.google.com/chart?'
        
    def generate(self, text = 'Generated by Kyu_Ar_Kowd_Jenereytor', imageOutput = '', width = 200, height = 200):
        
        if type(0) != type(width):
            raise JenereytorInvalidWidthException('Invalid width type')
        
        if type(0) != type(height):
            raise JenereytorInvalidHeightException('Invalid height type')
        
        if text.strip() == "":
            raise JenereytorInvalidTextException('Empty text')
        
        googleParam = {'chs':'%sx%s' % (width,height), 'cht':'qr', 'chl':text}
        completeGoogleUrl = self.googleUrl + urllib.urlencode(googleParam)
        
        try:
            response = urllib2.urlopen(completeGoogleUrl)
            
            if re.match(response.headers['Content-Type'], 'image/png'):
                
                try:
                    out = open(imageOutput, 'w')
                    
                    out.write(response.read())
                    
                    out.close()
                    
                    return True
                except:
                    return False
            else:
                return False
        except:
            return False