from django.conf.urls.defaults import url, patterns

urlpatterns = patterns(
    'lava_scheduler_app.views',
    url(r'^$', 
        'index',
        name='lava.scheduler'),
    url(r'^alljobs$', 
        'job_list', 
        name='lava.scheduler.job.list'),
    url(r'^device/(?P<pk>[-_a-zA-Z0-9]+)$', 
        'device_detail', 
        name='lava.scheduler.device.detail'),
    url(r'^device/(?P<pk>[-_a-zA-Z0-9]+)/maintenance$', 
        'device_maintenance_mode', 
        name='lava.scheduler.device.maintenance'),
    url(r'^device/(?P<pk>[-_a-zA-Z0-9]+)/online$',
        'device_online',
        name='lava.scheduler.device.online'),
    url(r'^job/(?P<pk>[0-9]+)$',
        'job_detail',
        name='lava.scheduler.job.detail'),
    url(r'^job/(?P<pk>[0-9]+)/definition$',
        'job_definition',
        name='lava.scheduler.job.definition'),
    url(r'^job/(?P<pk>[0-9]+)/definition/plain$',
            'job_definition_plain',
            name='lava.scheduler.job.definition.plain'),
    url(r'^job/(?P<pk>[0-9]+)/log_file$',
            'job_log_file',
            name='lava.scheduler.job.log_file'),
    url(r'^job/(?P<pk>[0-9]+)/log_file/plain$',
                'job_log_file_plain',
                name='lava.scheduler.job.log_file.plain'),
    url(r'^job/(?P<pk>[0-9]+)/cancel$',
        'job_cancel',
        name='lava.scheduler.job.cancel'),
    url(r'^job/(?P<pk>[0-9]+)/json$',
        'job_json', 
        name='lava.scheduler.job.json'),
    url(r'^job/(?P<pk>[0-9]+)/output$',
        'job_output',
        name='lava.scheduler.job.output'),
    url(r'^job/(?P<pk>[0-9]+)/log_incremental$',
        'job_log_incremental',
        name='lava.scheduler.job.log_incremental'),
    url(r'^job/(?P<pk>[0-9]+)/full_log_incremental$',
        'job_full_log_incremental',
        name='lava.scheduler.job.full_log_incremental'),
    )
