# Copyright (c) 2011 Linaro
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import abrek.testdef

RUNSTEPS = ['smem -w | tail -n 3']
PATTERN = "^(?P<test_case_id>(\w+\s)+)\s\s+(?P<measurement>\d+)"
DEPS = ['smem']

smeminst = abrek.testdef.AbrekTestInstaller(deps=DEPS)
smemrun = abrek.testdef.AbrekTestRunner(RUNSTEPS)
smemparser = abrek.testdef.AbrekTestParser(PATTERN,
               appendall={'units':'KB', 'result':'pass'})
testobj = abrek.testdef.AbrekTest(testname="smem", installer=smeminst,
                                  runner=smemrun, parser=smemparser)
