import sys
from pprint import pprint as pp
from ldapcache import *
from ldapdict import *

def runtests_ads():
    '''
    Tests for GenericLdapDict
    '''
    # url = "ldaps://localhost:636/"
    url = "ldap://apinfw01.pc.belastingdienst.nl:389/"
    user = 'CN=ux_ps_change,OU=Service Accounts,OU=Beheer,DC=pc,DC=Belastingdienst,DC=nl'
    passwd = 'Geheim01'

    ca = True
    sasl = True
    prod = False
    if prod:
        url = "ldap://10.73.1.1/"
        user = 'cn=tongp01,ou=CICT,ou=UID,dc=pc,dc=belastingdienst,dc=nl'
        # passwd = decrypt('SmFja0FzczEw')
        passwd = 'geheim'
        sasl = False
        ca = False

    if ca:
        cacert = '/etc/openldap/cacerts/116763c1.0'
    else:
        cacert = None

    if sasl:
        user = ''
        passwd = ''
        # mycert = '/etc/openldap/cacerts/ux_ps_read.pem'
        # mykey = '/etc/openldap/cacerts/ux_ps_read.priv.pem'
        mycert = '/etc/openldap/bu_tongp01.pem'
        mykey = '/etc/openldap/bu_tongp01.priv.pem'


    print url, user, "*******", cacert

    if sasl:
        lc = LdapCache(ADSLdapDict, url, user, passwd, cacert, mycert, mykey)
    else:
        lc = LdapCache(ADSLdapDict, url, user, passwd, cacert)
    root = lc.root
    bdn = lc.bdn

    print root.display()

#    print lc.who

    # root.ptex()
    # lc.printdnidx()
    tongp01 = ADSLdapDict('cn=bu_tongp01,ou=beheer,ou=UID,dc=pc,dc=belastingdienst,dc=nl', lc)
#
#    tongp01.getattr()
#
    print tongp01.display(True)
    print "MEMBEROF:"
    for group in tongp01.memberof:
        print str(group)

    print bdn
    return

    tgx_beh = GenericLdapDict('CN=tg_xbeh@MRS.Linux Servers.Midrange.HW,OU=MRS,OU=Linux Servers,OU=Midrange,OU=HW,DC=pc,DC=Belastingdienst,DC=nl', lc)
    tgx_beh.getattr()
    print tgx_beh.display()
    print "MEMBERS:"
    for user in tgx_beh.members:
        print str(user)

    # uid = GenericLdapDict('ou=cict,ou=UID,dc=pc,dc=belastingdienst,dc=nl', lc)
    uid = GenericLdapDict('ou=cict,ou=UID,dc=pc,dc=belastingdienst,dc=nl', lc)
    # uid.getattr()
    for key, value in uid.data.items():
        print "%35s : %r" % (key, value)

    # uid.gettree()

    lc.disconnect()
    print "Disconnected"
    pp(lc._getcon())
    try:
        user = GenericLdapDict('CN=tongp01,OU=CICT,OU=UID,DC=pc,DC=belastingdienst,DC=nl', lc)
    except:
        print sys.exc_info()[1]
    else:
        pp(user)

    lc.connect()
    print "Connected"
    pp(lc._getcon())
    try:
        user = GenericLdapDict('CN=tongp01,OU=CICT,OU=UID,DC=pc,DC=belastingdienst,DC=nl', lc)
    except:
        print sys.exc_info()[1]
    else:
        pp(user)

    user = GenericLdapDict('CN=tongp01,OU=CICT,OU=UID,DC=pc,DC=belastingdienst,DC=nl', lc)
    print user.display()
    print len(uid.children)

    rdn =  user - bdn

    print rdn, type(rdn)

    dn = bdn + rdn

    print dn, type(dn)
    print id(user)
    print id(dn)

    pp(dn.explode_dn())

    # print dn.display
    # bdn.printtree()

    # print host6.display(True)
    # print tongp01 - "ou=uid,dc=pc,dc=belastingdienst,dc=nl"
    # print uid + 'CN=bu_tongp01,OU=Beheer'

def runtests_ol():
    '''
    Tests for OpenLDAP
    '''
    from time import sleep

    url = "ldap://localhost:389/"
    user = 'cn=manager,dc=example,dc=com'
    passwd = 'secret'


    print url, user, passwd

    lc = LdapCacheWrite(GenericLdapDictWrite, url, user, passwd)
    root = lc.root
    bdn = lc.bdn
    print lc.printclassdef()
    lc.getclassdef(["person","inetorgperson", 'groupOfUniqueNames'])
    print lc.printclassdef()
    print lc.root.printtree()

    nlc = GenericLdapDictWrite.setldapcache(lc)

    lc = None

    print "root: %r" % (root)
    print root.display()
    print "bdn: %r" % (bdn)
    print bdn.display()

    admin = GenericLdapDictWrite(user, lc)
    print "admin: %r" % (admin)
    print admin.display()
    print id(admin)

    uid = GenericLdapDictWrite("ou=uid,dc=example,dc=com", lc)
    print uid.display(True)

    try:
        pieter = GenericLdapDictWrite('cn=pieter,ou=uid,dc=example,dc=com' , lc )
    except:
        print "create: pieter"
        pieter = uid.addchild("cn=pieter", ["inetorgperson"], {'sn' : 'van Tongeren', 'cn' : 'pieter', 'givenName' : 'Pieter'})

    try:
        groep = GenericLdapDictWrite('cn=groep,ou=uid,dc=example,dc=com' , lc )
    except:
        groep = uid.addchild("cn=groep", ["groupOfUniqueNames"], {'uniqueMember' : pieter.dn, 'cn' : 'groep'})
    uid.getchildren()

    groups = GenericLdapDictWrite('ou=groups,dc=example,dc=com' , lc )

    try:
        groep2 = GenericLdapDictWrite('cn=groep2,ou=groups,dc=example,dc=com' , lc )
    except:
        groep2 = groups.addchild("cn=groep2", ["groupOfNames"], {'member' : pieter.dn, 'cn' : 'groep2'})

    print pieter
    print groep2.display(True)
    print "leden groep2: ", groep2.getmembers()
    print "leden groep: ", groep.members
    print pieter.getmemberof()


    print uid.children
    print pieter.display(True)
    print groep.display(True)
    nlc.root.printtree()

    print pieter['givenName']
    print pieter['givenname']

    pieter['givenname'] = 'Hallo'
    pieter.commit()
    print pieter['givenname']

    pieter.deldn()

    print bdn
    return

    admin2 = GenericLdapDictWrite(user, lc)
    pieter = GenericLdapDictWrite("cn=pieter,ou=uid,dc=example,dc=com", lc)
    tongp01 = GenericLdapDictWrite("cn=tongp01,ou=uid,dc=example,dc=com", lc)
    host2 = GenericLdapDictWrite("cn=host2,ou=HW,dc=example,dc=com", lc)
    print id(admin2)
    print lc.printdnidx()

    bdn = GenericLdapDictWrite(bdn.dn, lc)
    bdn.gettree()
    bdn.printtree()

    print tongp01.display(True)
    for group in tongp01.memberof:
        print group

    pp(tongp01.explode_dn())

    tongp01.setattr({'description' : ['Pieter']}, False)
    print tongp01.display()

    tongp01['description'] = ['Leuke vent']

    tongp01.commit()
    # tongp01.getattr()
    print tongp01.display()

    host = GenericLdapDictWrite("cn=host5, ou=HW,"+bdn.dn, lc)

    print host.display()

#    classlist = host['objectClass']
#    attrdict = host.data
#    hostdn = host.dn
#
#    pp(hostdn)
#    pp(classlist)
#    pp(attrdict)

    host6 = GenericLdapDictWrite("cn=host6, ou=HW,"+bdn.dn, lc)
    host6.deldn()

    bdn.gettree()
    bdn.printtree()

    hostdn ='cn=host6,ou=HW,dc=example,dc=com'
    classlist = ['groupOfUniqueNames']
    attrdict = {'cn': ['Host6'],
         'uniqueMember': ['cn=tongp01,ou=UID,dc=example,dc=com']}

    bdn.adddn(hostdn, classlist, attrdict)

    host = GenericLdapDictWrite(hostdn, lc)

    print host.display()

    # print tongp01 - "ou=uid,dc=pc,dc=belastingdienst,dc=nl"
    # print uid + 'CN=bu_tongp01,OU=Beheer'
    
def runtests():
    try:
        runtests_ol()
    except:
        pass
    
    try:
        runtests_ads()
    except:
        print sys.exc_info()[:1]
    
if __name__ == "__main__":
    # _test()
    runtests()    
