import sys
from pprint import pprint as pp
import ldapcache
from ldapcache import *
from ldapdict import *

def main():
    url = "ldap:///"
    user = 'cn=manager,dc=example,dc=com'
    passwd = 'secret'
    cacert = '/etc/pki/tls/certs'
    cert = '/etc/pki/tls/certs/managercert.pem'
    key = '/etc/pki/tls/private/managerkey.pem' 

    print url, user, passwd

    lc = LdapCacheWrite(GenericLdapDictWrite, url, user, passwd, cacert, cert, key)
    root = lc.root
    bdn = lc.bdn
    
    lc.printclassdef()
    root.getattr(['+'])
    lc.getattr(root.dn, ['+'])
    pp(root.items())
    pp(root.data.items())
    pp(root.data) 
    
    print root['supportedSASLMechanisms']
    
    print root.display(True)
 

    
    print lc.printclassdef()
    lc.getclassdef(["person","inetorgperson", 'groupOfUniqueNames'])
    lc.printclassdef()
    lc.root.printtree()

    print lc.whoami().display()

    nlc = GenericLdapDictWrite.setldapcache(lc)
    
    uid = lc.bdn + 'ou=uid'

    
    try:
        pieter = uid + 'cn=pieter'
    except:
        print "Creating: pieter"
        classlist = ["inetorgperson", "person", "top"]
        pieter = uid.addchild('cn=pieter', classlist, {'sn' : 'van Tongeren', 'cn' : 'pieter', 'givenName' : 'Pieter', 'objectClass' : classlist})
    
    # pieter['userPassword'] = None
    
    print pieter.display(True)

    print pieter['userPassword']
    lc.ChangeLdapPasswd(pieter, 'Qwerty01')
    pieter.getattr(['userPassword'])    
    print pieter['userPassword']
    lc.ChangeLdapPasswd(pieter, 'Geheim01')
    pieter.getattr(['userPassword'])
    print pieter['userPassword']
    
    
    # pieter.deldn()            
    
    
if __name__ == "__main__":
    # _test()
    main()  