#!/usr/bin/python

from distutils.core import setup
import ldapcache
import ldapdict

setup(
    name         = 'ldapdict',
    version      = '1.4',
    author       = 'Pieter van Tongeren',
    author_email = 'pkvt.python@gmail.com',
    description  = 'Python package for connecting to LDAP, returning results as dictionary like classes. Results are cached.',
    url          = 'https://sourceforge.net/projects/python-ldapdict/',
    long_description = '\n'.join([
                                  'Contains two main modules ,which work together:\n  ldapdict and ldapcache\n',
                                  '--> ldapdict:',
                                  ldapdict.__doc__,
                                  '--> ldapcache:',
                                  ldapcache.__doc__,
                                  '\nBoth module are tested with OpenLDAP and ADS.',
                                  '\nDocumentation and examples can be found in the modules.' ]),
    platforms    = ['any'],
    packages     = ['ldapdict'],
    package_dir  = { 'ldapdict': '','ldapdict.examples': 'examples'},
)
