#!/usr/bin/env python
from setuptools import setup
import ldapper

setup(
    name = 'ldapper',
    version = ldapper.__version__,
    packages = [
        'ldapper'
    ],
    download_url = 'https://github.com/nrocco/ldapper',
    url = 'http://nrocco.github.io/',
    author = ldapper.__author__,
    author_email = 'dirocco.nico@gmail.com',
    description = "A python library that wraps the ldap module.",
    long_description = open('README.md').read(),
    include_package_data = True,
    license = open('LICENSE').read(),
    zip_safe = False,
    install_requires = [
        'python-ldap'
    ],
    classifiers = [
        'Development Status :: 5 - Production/Stable',
         'Operating System :: OS Independent',
         'Programming Language :: Python :: 2.6',
         'Programming Language :: Python :: 2.7',
         'Topic :: Software Development :: Libraries :: Python Modules',
    ],
)
