from ldif import LDIFWriter
from StringIO import StringIO

class LdapSearchResult(object):
    def __init__(self, item):
        self._raw = item
        self.dn = item[0]
        self.props = item[1]

    def __getitem__(self, key):
        if 'dn' == key:
            return self.dn
        else:
            return str(self.props[key])

    def has_property(self, prop):
        return prop in self.props

    def get(self, prop, default=None):
        if self.has_property(prop):
            return str(self.props[prop])
        else:
            return default

    def as_ldif(self):
        stream = StringIO()
        output = LDIFWriter(stream)
        output.unparse(self.dn, self.props)
        return stream.getvalue()

    def as_asci(self, delimiter=None):
        output = []
        output.append('****************************************')
        output.append('%s%s' % ('dn:'.ljust(18), self.dn))
        for key, value in self.props.iteritems():
            key = key + ':'
            output.append('%s%s' % (key.ljust(18), ', '.join(value)))
        output.append('****************************************')

        if isinstance(delimiter, str):
            return delimiter.join(output)
        else:
            return output

