from ldapper import messages

item = [
    'dn=admin,dc=example,dc=com',
    {
        'uid': '1000',
        'username': 'johndoe'
    }
]
message = messages.LdapSearchResult(item)


def test_check_existing_props():
    assert message.has_property('uid') == True
    assert message.has_property('username') == True


def test_check_nonexisting_props():
    assert message.has_property('nonexistent') == False


def test_get_dn():
    assert message['dn'] == 'dn=admin,dc=example,dc=com'


def test_non_existend_dn():
    assert message.get('dn') == None
    assert message.get('dn', 'test') == 'test'


def test_getting_props():
    assert message['uid'] == '1000'
    assert message.get('username') == 'johndoe'


def test_convert_to_ldif():
    assert type(message.as_ldif()) is str


def test_convert_to_ascii():
    assert type(message.as_asci()) is list
    assert type(message.as_asci('\n')) is str

