/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Linux Desktop Testing Project http://ldtp.freedesktop.org
 *
 * Author:
 *    Veerapuram Varadhan <v.varadhan@gmail.com>
 *
 * Copyright 2004 - 2006 Novell, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110, USA.
 */

#ifndef _LDTP_COMMAND_H
#define _LDTP_COMMAND_H

typedef enum _LDTPCommandId LDTPCommandId;

enum _LDTPCommandId {
	LDTP_CMD_INVALID = 0,
	LDTP_CMD_LOG,
	LDTP_CMD_STARTLOG,
	LDTP_CMD_STOPLOG,
	LDTP_CMD_CHECK ,
	LDTP_CMD_UNCHECK,
	LDTP_CMD_MENUCHECK ,
	LDTP_CMD_MENUUNCHECK,
	LDTP_CMD_CLICK,
	LDTP_CMD_VERIFYCHECK,
	LDTP_CMD_VERIFYUNCHECK, 
	LDTP_CMD_VERIFYMENUCHECK, 
	LDTP_CMD_VERIFYMENUUNCHECK, 
	LDTP_CMD_HIDELIST,
	LDTP_CMD_COMBOSELECT,
	LDTP_CMD_COMBOSELECTINDEX, 
	LDTP_CMD_SELECTINDEX ,
	LDTP_CMD_ISTEXTSTATEENABLED ,
	LDTP_CMD_SETTEXTVALUE ,
	LDTP_CMD_GETTEXTVALUE ,
	LDTP_CMD_APPENDTEXT ,
	LDTP_CMD_ACTIVATETEXT ,
	LDTP_CMD_CUTTEXT ,
	LDTP_CMD_PASTETEXT,
	LDTP_CMD_DELETETEXT,
	LDTP_CMD_SELECTTEXTBYNAME ,
	LDTP_CMD_SELECTTEXTBYINDEXANDREGION ,
	LDTP_CMD_SHOWLIST ,
	LDTP_CMD_VERIFYDROPDOWN ,
	LDTP_CMD_VERIFYHIDELIST ,
	LDTP_CMD_VERIFYSHOWLIST ,
	LDTP_CMD_VERIFYSELECT ,
	LDTP_CMD_VERIFYSETTEXT ,
	LDTP_CMD_RIGHTCLICK ,
	LDTP_CMD_GETLABEL ,
	LDTP_CMD_GETLABELATINDEX ,
	LDTP_CMD_SELECTPOPUPMENU ,
	LDTP_CMD_SELECTITEM ,
	LDTP_CMD_SELECTTEXTITEM ,
	LDTP_CMD_ISMENUITEMENABLED ,
	LDTP_CMD_SELECTMENUITEM ,
	LDTP_CMD_SELECTTAB ,
	LDTP_CMD_VERIFYPUSHBUTTON ,
	LDTP_CMD_STATEENABLED,
	LDTP_CMD_SETVALUE,
	LDTP_CMD_GETVALUE ,
	LDTP_CMD_VERIFYSETVALUE ,
	LDTP_CMD_SELECTROW ,
	LDTP_CMD_SELECTROWINDEX ,
	LDTP_CMD_SELECTROWPARTIALMATCH ,
	LDTP_CMD_VERIFYTOGGLED,
	LDTP_CMD_ONEDOWN,
	LDTP_CMD_ONEUP,
	LDTP_CMD_ONERIGHT, 
	LDTP_CMD_ONELEFT,
	LDTP_CMD_SCROLLDOWN, 
	LDTP_CMD_SCROLLUP,
	LDTP_CMD_SCROLLRIGHT,
	LDTP_CMD_SCROLLLEFT,
	LDTP_CMD_VERIFYSCROLLBAR,
	LDTP_CMD_VERIFYSCROLLBARVERTICAL,
	LDTP_CMD_VERIFYSCROLLBARHORIZONTAL,
	LDTP_CMD_SETMAX,
	LDTP_CMD_SETMIN ,
	LDTP_CMD_INCREASE ,
	LDTP_CMD_DECREASE ,
	LDTP_CMD_SELECTPANEL ,
	LDTP_CMD_SELECTPANELNAME ,
	LDTP_CMD_GETPANELCHILDCOUNT ,
	LDTP_CMD_VERIFYTABLECELL, 
	LDTP_CMD_SETCELLVALUE,
	LDTP_CMD_GETCELLVALUE ,
	LDTP_CMD_SELECTLASTROW ,
	LDTP_CMD_SELECTLABELSPANELBYNAME ,
	LDTP_CMD_SETCONTEXT ,
	LDTP_CMD_RELEASECONTEXT, 
	LDTP_CMD_GETSTATUSBARTEXT,
	LDTP_CMD_SELECTEVENT ,
	LDTP_CMD_SELECTEVENTINDEX ,
	LDTP_CMD_DOESROWEXIST,
	LDTP_CMD_DOESMENUITEMEXIST,
	LDTP_CMD_LISTSUBMENUS,
	LDTP_CMD_CHECKROW ,
	LDTP_CMD_VERIFYPARTIALMATCH,
	LDTP_CMD_GETROWCOUNT,
	LDTP_CMD_VERIFYPARTIALTABLECELL ,
	LDTP_CMD_GRABFOCUS,
	LDTP_CMD_VERIFYEVENTEXIST ,
	LDTP_CMD_EXPANDTABLECELL,
	LDTP_CMD_GETTREETABLEROWINDEX ,
	LDTP_CMD_VERIFYCHECKROW,
	LDTP_CMD_VERIFYUNCHECKROW,
	LDTP_CMD_VERIFYVISIBLEBUTTONCOUNT ,
	LDTP_CMD_VERIFYBUTTONCOUNT ,
	LDTP_CMD_GETEVENTCOUNT ,
	LDTP_CMD_DOUBLECLICKROW ,
	LDTP_CMD_GETTABLEROWINDEX,
	LDTP_CMD_GETCHARCOUNT,
	LDTP_CMD_COPYTEXT,
	LDTP_CMD_INSERTTEXT,
	LDTP_CMD_UNCHECKROW,
	LDTP_CMD_CAPTURETOFILE,
	LDTP_CMD_DOUBLECLICK,
	LDTP_CMD_GETTEXTPROPERTY,
	LDTP_CMD_COMPARETEXTPROPERTY,
	LDTP_CMD_CONTAINSTEXTPROPERTY,
	LDTP_CMD_SELECTCALENDARDATE,
	LDTP_CMD_SELECTTABINDEX ,
	LDTP_CMD_SORTCOLUMNINDEX ,
	LDTP_CMD_SORTCOLUMN,
	LDTP_CMD_REINITLDTP,
	LDTP_CMD_INITAPPMAP,
	LDTP_CMD_SETAPPMAP,
	LDTP_CMD_VERIFYSLIDER,
	LDTP_CMD_VERIFYSLIDERVERTICAL,
	LDTP_CMD_VERIFYSLIDERHORIZONTAL,
	LDTP_CMD_GETSLIDERVALUE,
	LDTP_CMD_VERIFYSTATUSBAR,
	LDTP_CMD_VERIFYSTATUSBARVISIBLE,
	LDTP_CMD_WAITTILLGUIEXIST,
	LDTP_CMD_WAITTILLGUINOTEXIST,
	LDTP_CMD_GUIEXIST,
	LDTP_CMD_ONWINDOWCREATE,
	LDTP_CMD_REMAP,
	LDTP_CMD_GETAPPLIST,
	LDTP_CMD_GETWINDOWLIST,
	LDTP_CMD_GETOBJECTLIST,
	LDTP_CMD_GETOBJECTINFO,
	LDTP_CMD_GETOBJECTPROPERTY,
	LDTP_CMD_BINDTEXT,
	LDTP_CMD_GENERATEMOUSEEVENT,
	LDTP_CMD_GENERATEKEYEVENT,
        LDTP_CMD_MOUSELEFTCLICK,
        LDTP_CMD_MOUSERIGHTCLICK,
        LDTP_CMD_MOUSEMOVE,
	LDTP_CMD_KBDENTER,
	LDTP_CMD_SETCURSOR,
	LDTP_CMD_GETCURSOR,
	LDTP_CMD_GETTABCOUNT,
	LDTP_CMD_STOPSCRIPTENGINE,
	LDTP_CMD_HASSTATE,
	LDTP_CMD_LAUNCHAPP,
	LDTP_CMD_SINGLECLICKROW,
	LDTP_CMD_SETLOCALE,
	LDTP_CMD_INVOKEMENU,
	LDTP_CMD_PRESS,
	LDTP_CMD_REMOVECALLBACK,
	LDTP_CMD_GUITIMEOUT,
	LDTP_CMD_OBJTIMEOUT,
	LDTP_CMD_GETCHILD
};

#endif
