#!/usr/bin/env python
from subprocess import check_call, check_output

from helpers import check_validity, get_repo_var, get_legion_var


def main():
    check_validity()

    # Get Legion values
    legion = get_legion_var()

    # Get current repo values
    repo = get_repo_var()

    print "Starting legion onto %s" % repo['heroku_name']

    # Duplicate server code onto /tmp
    check_output(['rm', '-rf', legion['tmp_server_path']])
    check_output(['cp', '-r', legion['server_path'], '/tmp/legion-server'])

    # Git init this
    check_output(['git', 'init'], cwd=legion['tmp_server_path'])
    check_output(['git', 'add', '.'], cwd=legion['tmp_server_path'])
    check_output(['git', 'commit', '-m', '"Load balancer"'], cwd=legion['tmp_server_path'])

    # Config heroku
    print "Creating balancer server, name `%s`" % repo['heroku_name']
    check_call(['heroku', 'apps:create', repo['heroku_name'],  '--buildpack', 'https://github.com/heroku/heroku-buildpack-nodejs#diet', '--remote', 'legion-balancer'], cwd=legion['tmp_server_path'])
    check_call(['git', 'push', 'legion-balancer', 'master'], cwd=legion['tmp_server_path'])


if __name__ == '__main__':
    main()
