#!/usr/bin/env python
from subprocess import check_output, check_call

from helpers import check_validity, get_repo_var, get_legion_var


def main():
    check_validity()

    print "Destroying legion"

    # List all remotes
    remotes = check_output(['git', 'remote', '-v']).split("\n")
    remote_names = set([])
    for remote in remotes:
        remote_name = remote.split("\t")[0]
        remote_names.add(remote_name)

    # Extract legion remotes
    legion_remotes = [remote for remote in remote_names if remote.startswith('legion-')]

    # Retrieve associated workers
    repo = get_repo_var(len(legion_remotes))
    for worker in repo['workers']:
        check_call(['heroku', 'apps:destroy', '-a', worker, '--confirm', worker])
    
    # Remove load balancer
    check_call(['heroku', 'apps:destroy', '-a', repo['heroku_name'], '--confirm', repo['heroku_name']])
    
    print "Your legion was dismantled by the Senate :("

if __name__ == '__main__':
    main()
