#!/usr/bin/env python
import sys
from subprocess import check_output, check_call, CalledProcessError

from helpers import check_validity, check_legion_created, get_repo_var

def main():
    check_validity()
    args = sys.argv
    if len(args) != 2:
        sys.exit("Scale needs a number.")

    scale = int(args[1])

    # Get current repo values
    repo = get_repo_var(scale)

    # Check we ran `legion create` before `scale`
    check_legion_created(repo['heroku_name'])

    for i, worker in enumerate(repo['workers']):
        remote_name = 'legion-%s' % i
        git_url = 'git@heroku.com:%s.git' % worker
        try:
            check_call(['heroku', 'apps:create', worker, '--remote', remote_name])
            check_call(['git', 'push', remote_name, 'master'])
            check_call(['heroku', 'ps:scale', 'web=1', '--app', worker])
        except CalledProcessError:
            # The app already exists, let's just add another remote
            try:
                check_call(['git', 'remote', 'add', remote_name, git_url])
            except CalledProcessError:
                print "Remote %s already exists" % i

    workers = ";".join(["%s.herokuapp.com" % worker for worker in repo['workers']])

    check_output(['heroku', 'config:set', 'WORKERS=%s' % workers, '--app', repo['heroku_name']])


if __name__ == '__main__':
    main()
